/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.authentication.password.htpasswd;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.authentication.password.AbstractPasswordHandler;
import com.alfaariss.oa.authentication.password.IResourceHandler;
import com.alfaariss.oa.authentication.password.htpasswd.HtPasswordResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class HtPasswdHandler
extends AbstractPasswordHandler {
    private final Log _logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void start(IConfigurationManager cm, Element eConfig) throws OAException {
        super.start(cm, eConfig);
        try {
            Element eResourceSection = cm.getSection(eConfig, "resource");
            if (eResourceSection == null) {
                this._logger.error((Object)"no htpasswd resource defined");
                throw new OAException(17);
            }
            while (eResourceSection != null) {
                HtPasswordResource oProtocolHandler = new HtPasswordResource();
                oProtocolHandler.init(cm, eResourceSection);
                this.addResourceHandler((IResourceHandler)oProtocolHandler);
                eResourceSection = cm.getNextSection(eResourceSection);
            }
            this.setDefault(cm, eConfig);
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during start of HTPasswordHandler", (Throwable)e);
            throw new OAException(1);
        }
    }
}

