/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.authentication.password.htpasswd;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.authentication.password.AbstractResourceHandler;
import com.alfaariss.oa.authentication.password.digest.HtPasswdMD5Digest;
import com.alfaariss.oa.authentication.password.digest.HtPasswdSHA1Digest;
import com.alfaariss.oa.authentication.password.digest.IDigest;
import com.alfaariss.oa.authentication.password.encode.BinaryPwdEncoder;
import com.alfaariss.oa.authentication.password.encode.IEncoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class HtPasswordResource
extends AbstractResourceHandler {
    private final Log _logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String _sFilename;
    private IDigest _md5digest;
    private IDigest _shadigest;
    private IEncoder _encoder = new BinaryPwdEncoder();

    public void init(IConfigurationManager cm, Element eResourceSection) throws OAException {
        String sCommand;
        super.init(cm, eResourceSection);
        Element eMD5 = cm.getSection(eResourceSection, "md5");
        if (eMD5 != null && (sCommand = cm.getParam(eMD5, "command")) != null) {
            this._md5digest = new HtPasswdMD5Digest(sCommand);
            this._md5digest.init(cm, null);
            this._logger.info((Object)("Using optional configured 'command': " + sCommand));
        }
        if (this._md5digest == null) {
            this._md5digest = new HtPasswdMD5Digest();
        }
        this._shadigest = new HtPasswdSHA1Digest();
        String sFile = cm.getParam(eResourceSection, "file");
        if (sFile == null || sFile.length() <= 0) {
            this._logger.error((Object)"No Htpasswd file configured in 'resource' section");
            throw new OAException(2);
        }
        File fFile = new File(sFile);
        if (!fFile.exists() || !fFile.isFile()) {
            this._logger.info((Object)("Configured file not found at: " + sFile));
            String sUserDir = System.getProperty("user.dir");
            StringBuffer sbFile = new StringBuffer(sUserDir);
            if (!sUserDir.endsWith(File.separator)) {
                sbFile.append(File.separator);
            }
            sbFile.append(sFile);
            fFile = new File(sbFile.toString());
            if (!fFile.exists()) {
                this._logger.error((Object)("Can't access file: " + sbFile.toString()));
                throw new OAException(2);
            }
        }
        this._sFilename = fFile.getAbsolutePath();
    }

    public boolean authenticate(String userPassword, String username) throws UserException, OAException {
        byte[] comparePw = this.getData(this.constructUsername(username));
        if (comparePw != null) {
            String sComparePassword = new String(comparePw);
            byte[] userPw = null;
            if (sComparePassword.startsWith("$apr1$")) {
                String[] spl = sComparePassword.split("\\$");
                String salt = spl[2];
                userPw = this._md5digest.digest(userPassword, salt, this.constructUsername(username));
            } else if (sComparePassword.startsWith("{SHA}")) {
                userPw = this._shadigest.digest(userPassword, this._sResourceRealm, username);
            } else {
                this._logger.error((Object)"Unknown htpasswd digest method");
                throw new OAException(1);
            }
            byte[] pww = this._encoder.getBytes(userPw);
            return Arrays.equals(pww, comparePw);
        }
        return false;
    }

    private byte[] getData(String username) throws OAException {
        byte[] result = null;
        try {
            String s;
            BufferedReader in = new BufferedReader(new FileReader(this._sFilename));
            do {
                String[] userhash;
                if ((s = in.readLine()) == null || !s.startsWith(username + ':') || (userhash = s.split(":", 2)).length != 2) continue;
                result = userhash[1].getBytes();
                this._logger.debug((Object)("Result from file: " + new String(result)));
                break;
            } while (s != null);
        }
        catch (FileNotFoundException e) {
            this._logger.error((Object)"File not found", (Throwable)e);
            throw new OAException(35);
        }
        catch (IOException e) {
            this._logger.error((Object)"Error reading file", (Throwable)e);
            throw new OAException(35);
        }
        return result;
    }
}

