/*
 * Decompiled with CFR 0.152.
 */
package com.alfaariss.oa.authentication.guest;

import com.alfaariss.oa.OAException;
import com.alfaariss.oa.UserEvent;
import com.alfaariss.oa.UserException;
import com.alfaariss.oa.api.configuration.IConfigurationManager;
import com.alfaariss.oa.api.logging.IAuthority;
import com.alfaariss.oa.api.session.ISession;
import com.alfaariss.oa.api.session.SessionState;
import com.alfaariss.oa.authentication.guest.bean.GuestUser;
import com.alfaariss.oa.engine.core.Engine;
import com.alfaariss.oa.engine.core.user.factory.IUserFactory;
import com.alfaariss.oa.sso.authentication.service.IServiceAuthenticationMethod;
import com.alfaariss.oa.sso.authentication.web.IWebAuthenticationMethod;
import com.alfaariss.oa.util.logging.UserEventLogItem;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class GuestAuthenticationMethod
implements IWebAuthenticationMethod,
IServiceAuthenticationMethod {
    private static final String AUTHORITY_NAME = "GuestAuthenticationMethod_";
    private Log _logger = LogFactory.getLog(GuestAuthenticationMethod.class);
    private Log _eventLogger = LogFactory.getLog((String)"com.alfaariss.oa.EventLogger");
    private boolean _bEnabled;
    private String _sMethodId = "";
    private String _sFriendlyName;
    private IConfigurationManager _configurationManager;
    private IUserFactory _oUserFactory;
    private String _sDefaultUserId = "";
    private String _sMyOrganization = "";

    public String getID() {
        return this._sMethodId;
    }

    public boolean isEnabled() {
        return this._bEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(Element eConfig) throws OAException {
        GuestAuthenticationMethod guestAuthenticationMethod = this;
        synchronized (guestAuthenticationMethod) {
            this.stop();
            this.start(this._configurationManager, eConfig);
        }
    }

    public void start(IConfigurationManager oConfigurationManager, Element eConfig) throws OAException {
        try {
            if (eConfig == null || oConfigurationManager == null) {
                this._logger.error((Object)"No configuration supplied");
                throw new OAException(17);
            }
            this._configurationManager = oConfigurationManager;
            this._oUserFactory = Engine.getInstance().getUserFactory();
            if (this._oUserFactory == null || !this._oUserFactory.isEnabled()) {
                this._logger.error((Object)"User Factory is disabled");
                throw new OAException(2);
            }
            this._sMethodId = this._configurationManager.getParam(eConfig, "id");
            if (this._sMethodId == null) {
                this._logger.error((Object)"No 'id' parameter found in configuration");
                throw new OAException(17);
            }
            this._sFriendlyName = this._configurationManager.getParam(eConfig, "friendlyname");
            if (this._sFriendlyName == null) {
                this._logger.error((Object)"No 'friendlyname' parameter found in configuration");
                throw new OAException(17);
            }
            this._bEnabled = true;
            String sEnabled = this._configurationManager.getParam(eConfig, "enabled");
            if (sEnabled != null) {
                if (sEnabled.equalsIgnoreCase("FALSE")) {
                    this._bEnabled = false;
                } else if (!sEnabled.equalsIgnoreCase("TRUE")) {
                    this._logger.error((Object)("Unknown value in 'enabled' configuration item: " + sEnabled));
                    throw new OAException(17);
                }
            }
            if (this._bEnabled) {
                Element eUser = this._configurationManager.getSection(eConfig, "user");
                if (eUser == null) {
                    this._logger.error((Object)"No 'user' section in 'method' configuration");
                    throw new OAException(17);
                }
                this._sDefaultUserId = this._configurationManager.getParam(eUser, "id");
                if (this._sDefaultUserId == null) {
                    this._logger.error((Object)"No 'id' parameter found in 'user' section in configuration");
                    throw new OAException(17);
                }
                if (this._sDefaultUserId.trim().length() == 0) {
                    this._logger.error((Object)"Empty 'id' parameter found in 'user' section in configuration");
                    throw new OAException(17);
                }
                this._sMyOrganization = Engine.getInstance().getServer().getOrganization().getID();
            }
        }
        catch (OAException e) {
            throw e;
        }
        catch (Exception e) {
            this._logger.fatal((Object)"Internal error during start", (Throwable)e);
            throw new OAException(1, (Throwable)e);
        }
    }

    public void stop() {
        this._bEnabled = false;
        this._sDefaultUserId = "";
        this._sMethodId = "";
        this._oUserFactory = null;
    }

    public String getAuthority() {
        return AUTHORITY_NAME + this._sMethodId;
    }

    public UserEvent authenticate(HttpServletRequest oRequest, HttpServletResponse oResponse, ISession oSession) throws OAException {
        UserEvent oUserEvent = UserEvent.AUTHN_METHOD_FAILED;
        try {
            Object oUser = oSession.getUser();
            if (oUser == null) {
                String sUserId = oSession.getForcedUserID();
                if (sUserId == null) {
                    sUserId = this._sDefaultUserId;
                }
                if ((oUser = this._oUserFactory.getUser(sUserId)) == null) {
                    oUser = new GuestUser(this._sMyOrganization, sUserId, this._sMethodId);
                }
                if (!oUser.isEnabled()) {
                    throw new UserException(UserEvent.USER_DISABLED);
                }
                if (!oUser.isAuthenticationRegistered(this._sMethodId)) {
                    throw new UserException(UserEvent.AUTHN_METHOD_NOT_REGISTERED);
                }
                oSession.setUser(oUser);
            } else if (!oUser.isAuthenticationRegistered(this._sMethodId)) {
                throw new UserException(UserEvent.AUTHN_METHOD_NOT_REGISTERED);
            }
            oUserEvent = UserEvent.AUTHN_METHOD_SUCCESSFUL;
            this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.AUTHN_METHOD_SUCCESSFUL, (IAuthority)this, null));
        }
        catch (UserException e) {
            oUserEvent = e.getEvent();
            this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), oUserEvent, (IAuthority)this, null));
        }
        catch (Exception e) {
            if (oSession != null) {
                this._eventLogger.info((Object)new UserEventLogItem(oSession, oRequest.getRemoteAddr(), UserEvent.INTERNAL_ERROR, (IAuthority)this, e.getMessage()));
            } else {
                this._eventLogger.info((Object)new UserEventLogItem(null, null, null, UserEvent.INTERNAL_ERROR, null, oRequest.getRemoteAddr(), null, (IAuthority)this, e.getMessage()));
            }
            this._logger.fatal((Object)"Fatal error during authentication", (Throwable)e);
            throw new OAException(1, (Throwable)e);
        }
        return oUserEvent;
    }

    public UserEvent authenticate(String sUserID, byte[] baCredentials) throws OAException {
        this._eventLogger.info((Object)new UserEventLogItem(null, null, SessionState.AUTHN_OK, UserEvent.AUTHN_METHOD_SUCCESSFUL, sUserID, null, null, null, null));
        return UserEvent.AUTHN_METHOD_SUCCESSFUL;
    }

    public String getFriendlyName() {
        return this._sFriendlyName;
    }
}

