/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.uritemplate;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.uri.UriEncoder;
import org.apache.wink.common.internal.uritemplate.UriTemplateProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxRsUriTemplateProcessor
extends UriTemplateProcessor {
    private static final String JAXRS_VARIABLE_PATTERN_WSP = "[ \\t]*";
    private static final String JAXRS_VARIABLE_PATTERN_NAME = "(\\w[\\w\\.-]*)";
    private static final String JAXRS_VARIABLE_PATTERN_NONBRACE = "[^{}]";
    private static final String JAXRS_VARIABLE_PATTERN_REGEX = "((?:(?:[^{}])|(?:\\{[^{}]*\\}))*)";
    private static final String JAXRS_VARIABLE_PATTERN_PARAM = "\\{[ \\t]*(\\w[\\w\\.-]*)[ \\t]*(?::[ \\t]*((?:(?:[^{}])|(?:\\{[^{}]*\\}))*)[ \\t]*)?\\}";
    private static final Pattern JAXRS_VARIABLE_PATTERN = Pattern.compile("\\{[ \\t]*(\\w[\\w\\.-]*)[ \\t]*(?::[ \\t]*((?:(?:[^{}])|(?:\\{[^{}]*\\}))*)[ \\t]*)?\\}");
    protected int numOfNonDefaultRegexes = 0;

    public JaxRsUriTemplateProcessor() {
    }

    public JaxRsUriTemplateProcessor(String template) {
        this();
        this.compile(template);
    }

    @Override
    protected void reset() {
        super.reset();
        this.numOfNonDefaultRegexes = 0;
    }

    @Override
    public final void compile(String template) {
        JaxRsUriTemplateProcessor.compile(template, new JaxRsPatternBuilder(this));
    }

    public static void compile(String template, JaxRsCompilationHandler handler) {
        if (template == null) {
            throw new NullPointerException("uriTemplate");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        int start = 0;
        String literal = "";
        handler.startCompile(template);
        Matcher matcher = JAXRS_VARIABLE_PATTERN.matcher(template);
        while (matcher.find()) {
            literal = template.substring(start, matcher.start());
            start = matcher.end();
            handler.literal(literal);
            String variable = matcher.group(1);
            String regex = matcher.group(2);
            handler.variable(variable, regex);
        }
        literal = template.substring(start);
        handler.endCompile(literal);
    }

    public static String expand(String template, MultivaluedMap<String, String> values) {
        if (template == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        JaxRsUriTemplateProcessor.expand(template, values, result);
        return result.toString();
    }

    public static void expand(String template, MultivaluedMap<String, String> values, StringBuilder out) {
        if (template == null) {
            return;
        }
        JaxRsTemplateExpander expander = new JaxRsTemplateExpander(values, out);
        JaxRsUriTemplateProcessor.compile(template, expander);
    }

    @Override
    public int compareTo(UriTemplateProcessor other) {
        int result = super.compareTo(other);
        if (result != 0) {
            return result;
        }
        if (!(other instanceof JaxRsUriTemplateProcessor)) {
            return result;
        }
        return this.compareNumOfNonDefaultRegexes((JaxRsUriTemplateProcessor)other);
    }

    private int compareNumOfNonDefaultRegexes(JaxRsUriTemplateProcessor jaxRsProcessor) {
        return this.numOfNonDefaultRegexes - jaxRsProcessor.numOfNonDefaultRegexes;
    }

    public static UriTemplateProcessor newNormalizedInstance(String uriTemplate) {
        return new JaxRsUriTemplateProcessor(UriTemplateProcessor.normalizeUri(uriTemplate));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JaxRsTemplateExpander
    extends UriTemplateProcessor.AbstractTemplateExpander
    implements JaxRsCompilationHandler {
        public JaxRsTemplateExpander(MultivaluedMap<String, String> values, StringBuilder out) {
            super(values, out);
        }

        @Override
        public void variable(String name, String regex) {
            if (this.values == null) {
                throw new NullPointerException(Messages.getMessage("variableNotSuppliedAValue", name));
            }
            String valueStr = (String)this.values.getFirst((Object)name);
            if (valueStr == null) {
                throw new NullPointerException(Messages.getMessage("variableNotSuppliedAValue", name));
            }
            this.out.append(valueStr);
        }
    }

    private static class JaxRsPatternBuilder
    extends UriTemplateProcessor.AbstractPatternBuilder
    implements JaxRsCompilationHandler {
        public JaxRsPatternBuilder(JaxRsUriTemplateProcessor processor) {
            super(processor);
        }

        public void literal(String literal) {
            super.literal(UriEncoder.encodeUriTemplate(literal, true));
        }

        public void variable(String name, String regex) {
            UriTemplateProcessor.CapturingGroup variable = this.createVariable(name, regex, null);
            this.processor.variables.add((Object)name, (Object)variable);
            this.processor.expanders.add(variable);
            if (regex != null) {
                ++((JaxRsUriTemplateProcessor)this.processor).numOfNonDefaultRegexes;
            }
        }

        protected void createTail() {
            if (this.processor.template.equals("")) {
                this.processor.tail = this.createVariable("wink.TemplateTail", "(.*)?", null);
            } else {
                super.createTail();
            }
        }
    }

    public static interface JaxRsCompilationHandler
    extends UriTemplateProcessor.BaseCompilationHandler {
        public void variable(String var1, String var2);
    }
}

