/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionAdapter;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionUtil;
import org.apache.tools.ant.taskdefs.optional.extension.LibFileSet;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;

public class ExtensionSet
extends DataType {
    private final ArrayList extensions = new ArrayList();
    private final ArrayList extensionsFilesets = new ArrayList();

    public void addExtension(ExtensionAdapter extensionAdapter) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.setChecked(false);
        this.extensions.add(extensionAdapter);
    }

    public void addLibfileset(LibFileSet fileSet) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.setChecked(false);
        this.extensionsFilesets.add(fileSet);
    }

    public void addFileset(FileSet fileSet) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.setChecked(false);
        this.extensionsFilesets.add(fileSet);
    }

    public Extension[] toExtensions(Project proj) throws BuildException {
        if (this.isReference()) {
            return ((ExtensionSet)((Object)this.getCheckedRef())).toExtensions(proj);
        }
        this.dieOnCircularReference();
        ArrayList extensionsList = ExtensionUtil.toExtensions(this.extensions);
        ExtensionUtil.extractExtensions(proj, extensionsList, this.extensionsFilesets);
        return extensionsList.toArray(new Extension[extensionsList.size()]);
    }

    public void setRefid(Reference reference) throws BuildException {
        if (!this.extensions.isEmpty() || !this.extensionsFilesets.isEmpty()) {
            throw this.tooManyAttributes();
        }
        super.setRefid(reference);
    }

    protected synchronized void dieOnCircularReference(Stack stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            Iterator i = this.extensions.iterator();
            while (i.hasNext()) {
                ExtensionSet.pushAndInvokeCircularReferenceCheck((DataType)((ExtensionAdapter)((Object)i.next())), (Stack)stk, (Project)p);
            }
            i = this.extensionsFilesets.iterator();
            while (i.hasNext()) {
                ExtensionSet.pushAndInvokeCircularReferenceCheck((DataType)((FileSet)i.next()), (Stack)stk, (Project)p);
            }
            this.setChecked(true);
        }
    }

    public String toString() {
        return "ExtensionSet" + Arrays.asList(this.toExtensions(this.getProject()));
    }
}

