/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.journal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.activemq.store.kahadb.disk.journal.DataFile;
import org.apache.activemq.store.kahadb.disk.journal.Journal;
import org.apache.activemq.store.kahadb.disk.journal.Location;
import org.apache.activemq.store.kahadb.disk.journal.ReadOnlyDataFile;

public class ReadOnlyJournal
extends Journal {
    private final ArrayList<File> dirs;

    public ReadOnlyJournal(ArrayList<File> dirs) {
        this.dirs = dirs;
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.started) {
            return;
        }
        this.started = true;
        ArrayList<File> files = new ArrayList<File>();
        Iterator<File> i$ = this.dirs.iterator();
        while (i$.hasNext()) {
            File directory;
            final File d = directory = i$.next();
            File[] f = d.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String n) {
                    return dir.equals(d) && n.startsWith(ReadOnlyJournal.this.filePrefix);
                }
            });
            for (int i = 0; i < f.length; ++i) {
                files.add(f[i]);
            }
        }
        for (File file : files) {
            try {
                String n = file.getName();
                String numStr = n.substring(this.filePrefix.length(), n.length());
                int num = Integer.parseInt(numStr);
                ReadOnlyDataFile dataFile = new ReadOnlyDataFile(file, num);
                this.fileMap.put(dataFile.getDataFileId(), dataFile);
                this.totalLength.addAndGet(dataFile.getLength());
            }
            catch (NumberFormatException n) {}
        }
        ArrayList list = new ArrayList(this.fileMap.values());
        Collections.sort(list);
        for (DataFile df : list) {
            this.dataFiles.addLast(df);
            this.fileByFileMap.put(df.getFile(), df);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.started) {
            return;
        }
        this.accessorPool.close();
        this.fileMap.clear();
        this.fileByFileMap.clear();
        this.started = false;
    }

    public Location getFirstLocation() throws IllegalStateException, IOException {
        if (this.dataFiles.isEmpty()) {
            return null;
        }
        DataFile first = (DataFile)this.dataFiles.getHead();
        Location cur = new Location();
        cur.setDataFileId(first.getDataFileId());
        cur.setOffset(0);
        cur.setSize(0);
        return this.getNextLocation(cur);
    }

    @Override
    public synchronized boolean delete() throws IOException {
        throw new RuntimeException("Cannot delete a ReadOnlyAsyncDataManager");
    }
}

