/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.dom;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.css.dom.CSSStyleDeclarationImpl;
import com.gargoylesoftware.css.dom.CSSStyleSheetImpl;
import com.gargoylesoftware.css.dom.DOMExceptionImpl;
import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.css.parser.CSSOMParser;
import com.gargoylesoftware.css.parser.InputSource;
import com.gargoylesoftware.css.util.LangUtils;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.DOMException;

public class CSSPageRuleImpl
extends AbstractCSSRuleImpl {
    private String pseudoPage_;
    private CSSStyleDeclarationImpl style_;

    public CSSPageRuleImpl(CSSStyleSheetImpl parentStyleSheet, AbstractCSSRuleImpl parentRule, String pseudoPage) {
        super(parentStyleSheet, parentRule);
        this.pseudoPage_ = pseudoPage;
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder();
        String sel = this.getSelectorText();
        sb.append("@page ").append(sel);
        if (sel.length() > 0) {
            sb.append(" ");
        }
        sb.append("{");
        CSSStyleDeclarationImpl style = this.getStyle();
        if (null != style) {
            sb.append(style.getCssText());
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        block16: {
            try (InputSource is = new InputSource(new StringReader(cssText));){
                CSSOMParser parser = new CSSOMParser();
                AbstractCSSRuleImpl r = parser.parseRule(is);
                if (r instanceof CSSPageRuleImpl) {
                    this.pseudoPage_ = ((CSSPageRuleImpl)r).pseudoPage_;
                    this.style_ = ((CSSPageRuleImpl)r).style_;
                    break block16;
                }
                throw new DOMExceptionImpl(13, 8);
            }
            catch (CSSException e) {
                throw new DOMExceptionImpl(12, 0, e.getMessage());
            }
            catch (IOException e) {
                throw new DOMExceptionImpl(12, 0, e.getMessage());
            }
        }
    }

    public String getSelectorText() {
        if (null == this.pseudoPage_) {
            return "";
        }
        return this.pseudoPage_;
    }

    public CSSStyleDeclarationImpl getStyle() {
        return this.style_;
    }

    public void setStyle(CSSStyleDeclarationImpl style) {
        this.style_ = style;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSPageRuleImpl)) {
            return false;
        }
        CSSPageRuleImpl cpr = (CSSPageRuleImpl)obj;
        return super.equals(obj) && LangUtils.equals(this.getSelectorText(), cpr.getSelectorText()) && LangUtils.equals(this.getStyle(), cpr.getStyle());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = LangUtils.hashCode(hash, this.pseudoPage_);
        hash = LangUtils.hashCode(hash, this.style_);
        return hash;
    }

    public String toString() {
        return this.getCssText();
    }
}

