/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.parser;

import com.gargoylesoftware.css.dom.CSSCharsetRuleImpl;
import com.gargoylesoftware.css.dom.CSSFontFaceRuleImpl;
import com.gargoylesoftware.css.dom.CSSImportRuleImpl;
import com.gargoylesoftware.css.dom.CSSMediaRuleImpl;
import com.gargoylesoftware.css.dom.CSSPageRuleImpl;
import com.gargoylesoftware.css.dom.CSSRuleListImpl;
import com.gargoylesoftware.css.dom.CSSStyleDeclarationImpl;
import com.gargoylesoftware.css.dom.CSSStyleRuleImpl;
import com.gargoylesoftware.css.dom.CSSStyleSheetImpl;
import com.gargoylesoftware.css.dom.CSSUnknownRuleImpl;
import com.gargoylesoftware.css.dom.CSSValueImpl;
import com.gargoylesoftware.css.dom.MediaListImpl;
import com.gargoylesoftware.css.dom.Property;
import com.gargoylesoftware.css.parser.AbstractCSSParser;
import com.gargoylesoftware.css.parser.CSSErrorHandler;
import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.css.parser.CSSParser;
import com.gargoylesoftware.css.parser.DocumentHandler;
import com.gargoylesoftware.css.parser.HandlerBase;
import com.gargoylesoftware.css.parser.InputSource;
import com.gargoylesoftware.css.parser.LexicalUnit;
import com.gargoylesoftware.css.parser.Locator;
import com.gargoylesoftware.css.parser.javacc.CSS3Parser;
import com.gargoylesoftware.css.parser.media.MediaQueryList;
import com.gargoylesoftware.css.parser.selector.SelectorList;
import java.io.IOException;
import java.util.Stack;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSOMParser {
    private CSSParser parser_;
    private CSSStyleSheetImpl parentStyleSheet_;

    public CSSOMParser(CSSParser parser) {
        this.parser_ = parser;
    }

    public CSSOMParser() {
        this.parser_ = new CSS3Parser();
    }

    public void setErrorHandler(CSSErrorHandler eh) {
        this.parser_.setErrorHandler(eh);
    }

    public CSSStyleSheetImpl parseStyleSheet(InputSource source, String href) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        handler.setHref(href);
        this.parser_.setDocumentHandler(handler);
        this.parser_.parseStyleSheet(source);
        Object o = handler.getRoot();
        if (o instanceof CSSStyleSheetImpl) {
            return (CSSStyleSheetImpl)o;
        }
        return null;
    }

    public CSSStyleDeclaration parseStyleDeclaration(InputSource source) throws IOException {
        CSSStyleDeclarationImpl sd = new CSSStyleDeclarationImpl(null);
        this.parseStyleDeclaration(sd, source);
        return sd;
    }

    public void parseStyleDeclaration(CSSStyleDeclaration sd, InputSource source) throws IOException {
        Stack<Object> nodeStack = new Stack<Object>();
        nodeStack.push(sd);
        CSSOMHandler handler = new CSSOMHandler(nodeStack);
        this.parser_.setDocumentHandler(handler);
        this.parser_.parseStyleDeclaration(source);
    }

    public CSSValue parsePropertyValue(InputSource source) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        this.parser_.setDocumentHandler(handler);
        LexicalUnit lu = this.parser_.parsePropertyValue(source);
        if (null == lu) {
            return null;
        }
        return new CSSValueImpl(lu);
    }

    public CSSRule parseRule(InputSource source) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        this.parser_.setDocumentHandler(handler);
        this.parser_.parseRule(source);
        return (CSSRule)handler.getRoot();
    }

    public SelectorList parseSelectors(InputSource source) throws IOException {
        HandlerBase handler = new HandlerBase();
        this.parser_.setDocumentHandler(handler);
        return this.parser_.parseSelectors(source);
    }

    public MediaQueryList parseMedia(InputSource source) throws IOException {
        HandlerBase handler = new HandlerBase();
        this.parser_.setDocumentHandler(handler);
        if (this.parser_ instanceof AbstractCSSParser) {
            return ((AbstractCSSParser)this.parser_).parseMedia(source);
        }
        return null;
    }

    public void setParentStyleSheet(CSSStyleSheetImpl parentStyleSheet) {
        this.parentStyleSheet_ = parentStyleSheet;
    }

    protected CSSStyleSheetImpl getParentStyleSheet() {
        return this.parentStyleSheet_;
    }

    class CSSOMHandler
    implements DocumentHandler {
        private Stack<Object> nodeStack_;
        private Object root_;
        private String href_;

        private String getHref() {
            return this.href_;
        }

        private void setHref(String href) {
            this.href_ = href;
        }

        CSSOMHandler(Stack<Object> nodeStack) {
            this.nodeStack_ = nodeStack;
        }

        CSSOMHandler() {
            this.nodeStack_ = new Stack();
        }

        Object getRoot() {
            return this.root_;
        }

        @Override
        public void startDocument(InputSource source) throws CSSException {
            if (this.nodeStack_.empty()) {
                CSSStyleSheetImpl ss = new CSSStyleSheetImpl();
                CSSOMParser.this.setParentStyleSheet(ss);
                ss.setHref(this.getHref());
                ss.setMediaText(source.getMedia());
                ss.setTitle(source.getTitle());
                CSSRuleListImpl rules = new CSSRuleListImpl();
                ss.setCssRules(rules);
                this.nodeStack_.push(ss);
                this.nodeStack_.push(rules);
            }
        }

        @Override
        public void endDocument(InputSource source) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        @Override
        public void ignorableAtRule(String atRule, Locator locator) throws CSSException {
            CSSUnknownRuleImpl ir = new CSSUnknownRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), atRule);
            ir.setLocator(locator);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(ir);
            } else {
                this.root_ = ir;
            }
        }

        @Override
        public void charset(String characterEncoding, Locator locator) throws CSSException {
            CSSCharsetRuleImpl cr = new CSSCharsetRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), characterEncoding);
            cr.setLocator(locator);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(cr);
            } else {
                this.root_ = cr;
            }
        }

        @Override
        public void importStyle(String uri, MediaQueryList media, String defaultNamespaceURI, Locator locator) throws CSSException {
            CSSImportRuleImpl ir = new CSSImportRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), uri, new MediaListImpl(media));
            ir.setLocator(locator);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(ir);
            } else {
                this.root_ = ir;
            }
        }

        @Override
        public void startMedia(MediaQueryList media, Locator locator) throws CSSException {
            MediaListImpl ml = new MediaListImpl(media);
            CSSMediaRuleImpl mr = new CSSMediaRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), ml);
            mr.setLocator(locator);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(mr);
            }
            CSSRuleListImpl rules = new CSSRuleListImpl();
            mr.setRuleList(rules);
            this.nodeStack_.push(mr);
            this.nodeStack_.push(rules);
        }

        @Override
        public void endMedia(MediaQueryList media) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        @Override
        public void startPage(String name, String pseudoPage, Locator locator) throws CSSException {
            CSSPageRuleImpl pr = new CSSPageRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), pseudoPage);
            pr.setLocator(locator);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(pr);
            }
            CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(pr);
            pr.setStyle(decl);
            this.nodeStack_.push(pr);
            this.nodeStack_.push(decl);
        }

        @Override
        public void endPage(String name, String pseudoPage) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        @Override
        public void startFontFace(Locator locator) throws CSSException {
            CSSFontFaceRuleImpl ffr = new CSSFontFaceRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule());
            ffr.setLocator(locator);
            if (!this.nodeStack_.empty()) {
                ((CSSRuleListImpl)this.nodeStack_.peek()).add(ffr);
            }
            CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(ffr);
            ffr.setStyle(decl);
            this.nodeStack_.push(ffr);
            this.nodeStack_.push(decl);
        }

        @Override
        public void endFontFace() throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        @Override
        public void startSelector(SelectorList selectors, Locator locator) throws CSSException {
            CSSStyleRuleImpl sr = new CSSStyleRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), selectors);
            sr.setLocator(locator);
            if (!this.nodeStack_.empty()) {
                Object o = this.nodeStack_.peek();
                ((CSSRuleListImpl)o).add(sr);
            }
            CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(sr);
            sr.setStyle(decl);
            this.nodeStack_.push(sr);
            this.nodeStack_.push(decl);
        }

        @Override
        public void endSelector(SelectorList selectors) throws CSSException {
            this.nodeStack_.pop();
            this.root_ = this.nodeStack_.pop();
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important, Locator locator) {
            block2: {
                CSSStyleDeclarationImpl decl = (CSSStyleDeclarationImpl)this.nodeStack_.peek();
                try {
                    Property property = new Property(name, new CSSValueImpl(value), important);
                    property.setLocator(locator);
                    decl.addProperty(property);
                }
                catch (DOMException e) {
                    if (!(CSSOMParser.this.parser_ instanceof AbstractCSSParser)) break block2;
                    AbstractCSSParser parser = (AbstractCSSParser)CSSOMParser.this.parser_;
                    parser.getErrorHandler().error(parser.toCSSParseException(e));
                }
            }
        }

        private CSSRule getParentRule() {
            Object node;
            if (!this.nodeStack_.empty() && this.nodeStack_.size() > 1 && (node = this.nodeStack_.get(this.nodeStack_.size() - 2)) instanceof CSSRule) {
                return (CSSRule)node;
            }
            return null;
        }
    }
}

