/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.wsa;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MessageID
extends AbstractSignableXMLObject
implements AttributeExtensibleXMLObject {
    private static SecureRandomIdentifierGenerationStrategy idGenerator;
    public static final String DEFAULT_ELEMENT_LOCAL_NAME = "MessageID";
    public static final QName DEFAULT_ELEMENT_NAME;
    private String value;
    private AttributeMap otherAttributes;

    public MessageID() {
        super("http://www.w3.org/2005/08/addressing", DEFAULT_ELEMENT_LOCAL_NAME, "wsa");
        if (null == idGenerator) {
            idGenerator = new SecureRandomIdentifierGenerationStrategy();
        }
        if (null != idGenerator) {
            this.setValue("olid:" + idGenerator.generateIdentifier());
        } else {
            this.setValue("uuid:" + UUID.randomUUID().toString());
        }
    }

    protected MessageID(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
        this.otherAttributes = new AttributeMap((XMLObject)this);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        this.value = this.prepareForAssignment(this.value, newValue);
    }

    public AttributeMap getUnknownAttributes() {
        if (null == this.otherAttributes) {
            this.otherAttributes = new AttributeMap((XMLObject)this);
        }
        return this.otherAttributes;
    }

    public List<XMLObject> getOrderedChildren() {
        return null;
    }

    static {
        DEFAULT_ELEMENT_NAME = QNameSupport.constructQName((String)"http://www.w3.org/2005/08/addressing", (String)DEFAULT_ELEMENT_LOCAL_NAME, (String)"wsa");
    }

    public static class Builder
    extends AbstractXMLObjectBuilder<MessageID> {
        public MessageID buildObject(String namespaceURI, String localName, String namespacePrefix) {
            return new MessageID(namespaceURI, localName, namespacePrefix);
        }
    }

    public static class Marshaller
    extends AbstractXMLObjectMarshaller {
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
            MessageID obj = (MessageID)xmlObject;
            for (Map.Entry entry : obj.getUnknownAttributes().entrySet()) {
                Attr attr = AttributeSupport.constructAttribute((Document)domElement.getOwnerDocument(), (QName)((QName)entry.getKey()));
                attr.setValue((String)entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (!XMLObjectProviderRegistrySupport.isIDAttribute((QName)((QName)entry.getKey())) && !obj.getUnknownAttributes().isIDAttribute((QName)entry.getKey())) continue;
                attr.getOwnerElement().setIdAttributeNode(attr, true);
            }
        }

        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException {
            MessageID obj = (MessageID)xmlObject;
            ElementSupport.appendTextContent((Element)domElement, (String)obj.getValue());
        }
    }

    public static class Unmarshaller
    extends AbstractXMLObjectUnmarshaller {
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
            MessageID obj = (MessageID)xmlObject;
            QName attribQName = QNameSupport.getNodeQName((Node)attribute);
            if (attribute.isId()) {
                obj.getUnknownAttributes().registerID(attribQName);
            }
            obj.getUnknownAttributes().put(attribQName, attribute.getValue());
        }

        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
        }

        protected void processElementContent(XMLObject xmlObject, String elementContent) {
            MessageID obj = (MessageID)xmlObject;
            if (elementContent != null) {
                obj.setValue(elementContent.trim());
            }
        }
    }
}

