/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.utility_2_0;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class Status
extends AbstractSignableXMLObject {
    public static final String LOCAL_NAME = "Status";
    public static final QName LOCAL_Q_NAME = new QName("urn:liberty:util:2006-08", "Status", "lu");
    public static final String CONTINUE = "Continue";
    public static final String OK = "OK";
    public static final String FAILED = "Failed";
    public static String ATT_CODE = "code";
    public static String ATT_REF = "ref";
    public static String ATT_COMMENT = "comment";
    private String code;
    private String ref;
    private String comment;
    private XMLObjectChildrenList<Status> stati;

    protected Status(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public String getCode() {
        return this.code;
    }

    public boolean isFailed() {
        return null != this.code && this.code.endsWith(FAILED);
    }

    public boolean isOK() {
        return null != this.code && this.code.endsWith(OK);
    }

    public void setCode(String code) {
        this.code = this.prepareForAssignment(this.code, code);
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = this.prepareForAssignment(this.ref, ref);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = this.prepareForAssignment(this.comment, comment);
    }

    public XMLObjectChildrenList<Status> getStati() {
        if (null == this.stati) {
            this.stati = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.stati;
    }

    public List<XMLObject> getOrderedChildren() {
        LinkedList<Status> children = new LinkedList<Status>();
        if (null != this.stati) {
            children.addAll((Collection<Status>)this.stati);
        }
        return Collections.unmodifiableList(children);
    }

    public static class Builder
    extends AbstractXMLObjectBuilder<Status> {
        public Status buildObject() {
            return this.buildObject("urn:liberty:util:2006-08", Status.LOCAL_NAME, "lu");
        }

        public Status buildObject(String namespaceURI, String localName, String namespacePrefix) {
            return new Status(namespaceURI, localName, namespacePrefix);
        }
    }

    public static class Marshaller
    extends AbstractXMLObjectMarshaller {
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
            Status status = (Status)xmlObject;
            if (status.getCode() != null) {
                domElement.setAttributeNS(null, ATT_CODE, status.getCode());
            }
            if (status.getComment() != null) {
                domElement.setAttributeNS(null, ATT_COMMENT, status.getComment());
            }
            if (status.getRef() != null) {
                domElement.setAttributeNS(null, ATT_REF, status.getRef());
            }
        }

        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException {
        }
    }

    public static class Unmarshaller
    extends AbstractXMLObjectUnmarshaller {
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
            Status status = (Status)xmlObject;
            if (attribute.getLocalName().equals(ATT_CODE)) {
                status.setCode(attribute.getValue());
            } else if (attribute.getLocalName().equals(ATT_REF)) {
                status.setRef(attribute.getValue());
            } else if (attribute.getLocalName().equals(ATT_COMMENT)) {
                status.setComment(attribute.getValue());
            }
        }

        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
            if (childXMLObject instanceof Status) {
                ((Status)parentXMLObject).getStati().add((Object)((Status)childXMLObject));
            }
        }

        protected void processElementContent(XMLObject xmlObject, String elementContent) {
        }
    }

    public static enum StatusCode {
        INVALIDACTOR("InvalidActor", "There is an issue with the actor attribute on the indicated header block in the indicated message.", "C"),
        INVALIDMUSTUNDERSTAND("InvalidMustUnderstand", "There is an issue with the mustUnderstand attribute on the indicated header block in the indicated message.", "C");

        private final String code;
        private final String semantics;
        private final String source;

        private StatusCode(String code, String semantics, String source) {
            this.code = code;
            this.semantics = semantics;
            this.source = source;
        }

        public boolean isClientSource() {
            return "C".equals(this.source);
        }

        public boolean isServerSource() {
            return "S".equals(this.source);
        }

        public String getCode() {
            return this.code;
        }

        public String getSemantics() {
            return this.semantics;
        }

        public String getSource() {
            return this.source;
        }
    }
}

