/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.idsis.dap;

import java.util.Hashtable;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.openliberty.xmltooling.dst2_1.PaginationResponseAttributeGroup;
import org.openliberty.xmltooling.idsis.dap.DAPItemData;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class DAPData
extends DAPItemData {
    private final Logger log = LoggerFactory.getLogger(DAPData.class);
    private PaginationResponseAttributeGroup paginationResponseAttributeGroup = new PaginationResponseAttributeGroup();
    private String value;

    public DAPData() {
        super("urn:liberty:id-sis-dap:2006-02:dst-2.1", LOCAL_NAME, "dap");
        if (this.log.isDebugEnabled()) {
            this.log.debug("new DAPData()");
        }
    }

    public DAPData(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
        if (this.log.isDebugEnabled()) {
            this.log.debug("new DAPData(" + namespaceURI + ", " + elementLocalName + ", " + namespacePrefix + ")");
        }
    }

    public String getLDIFDataString() {
        if (null == this.getSubscription()) {
            if (null != this.getLDIF()) {
                return this.getLDIF().getValue();
            }
            return this.value;
        }
        return null;
    }

    public Hashtable<String, String> getLDIFDataAsHashtable() {
        Hashtable<String, String> hashedData = new Hashtable<String, String>();
        String data = this.getLDIFDataString();
        if (null != data) {
            String[] attributes;
            for (String attribute : attributes = data.split("\\n")) {
                int colon = attribute.indexOf(58);
                if (colon <= 1) continue;
                hashedData.put(attribute.substring(0, colon), attribute.length() > colon ? attribute.substring(colon + 1).trim() : "");
            }
        }
        return hashedData;
    }

    public void setValue(String value) {
        this.value = this.prepareForAssignment(this.value, value);
    }

    public String getValue() {
        return this.value;
    }

    public PaginationResponseAttributeGroup getPaginationResponseAttributes() {
        return this.paginationResponseAttributeGroup;
    }

    public static class Builder
    extends AbstractXMLObjectBuilder<DAPData> {
        public DAPData buildObject() {
            return new DAPData("urn:liberty:id-sis-dap:2006-02:dst-2.1", DAPItemData.LOCAL_NAME, "dap");
        }

        public DAPData buildObject(String namespaceURI, String localName, String namespacePrefix) {
            return new DAPData(namespaceURI, localName, namespacePrefix);
        }
    }

    public static class Unmarshaller
    extends DAPItemData.Unmarshaller {
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
            DAPData obj = (DAPData)xmlObject;
            if (!obj.getPaginationResponseAttributes().processAttribute(attribute, (AbstractXMLObject)obj)) {
                super.processAttribute(xmlObject, attribute);
            }
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) {
            DAPData obj = (DAPData)xmlObject;
            obj.setValue(elementContent);
        }
    }

    public static class Marshaller
    extends DAPItemData.Marshaller {
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
            DAPData obj = (DAPData)xmlObject;
            obj.getPaginationResponseAttributes().marshallAttributes(domElement);
            super.marshallAttributes(xmlObject, domElement);
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException {
            DAPData obj = (DAPData)xmlObject;
            ElementSupport.appendTextContent((Element)domElement, (String)obj.getValue());
        }
    }
}

