/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.dst2_1;

import org.joda.time.DateTime;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.dst2_1.SelectQualifAttributes;
import org.opensaml.core.xml.AbstractXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ModifyItemAttributeGroup
extends SelectQualifAttributes {
    public static final String NOT_CHANGED_SINCE = "notChangedSince";
    public static final String OVERRIDE_ALLOWED = "overrideAllowed";
    public static final String ID = "id";
    public static final String ITEM_ID = "itemID";
    private DateTime notChangedSince;
    private Boolean overrideAllowed;
    private String id;
    private String itemID;

    @Override
    public void marshallAttributes(Element domElement) {
        super.marshallAttributes(domElement);
        if (this.notChangedSince != null) {
            domElement.setAttributeNS(null, NOT_CHANGED_SINCE, OpenLibertyHelpers.stringForDateTime(this.notChangedSince));
        }
        if (this.overrideAllowed != null) {
            domElement.setAttributeNS(null, OVERRIDE_ALLOWED, OpenLibertyHelpers.stringFromBoolean(this.overrideAllowed, OpenLibertyHelpers.FALSE_STR));
        }
        if (this.id != null) {
            domElement.setAttributeNS(null, ID, this.id);
            domElement.setIdAttributeNS(null, ID, true);
        }
        if (this.itemID != null) {
            domElement.setAttributeNS(null, ITEM_ID, this.itemID);
        }
    }

    @Override
    public boolean processAttribute(Attr attribute, AbstractXMLObject abstractXMLObject) {
        if (!super.processAttribute(attribute, abstractXMLObject)) {
            if (attribute.getLocalName().equals(ID)) {
                this.setId(attribute.getValue(), abstractXMLObject);
                attribute.getOwnerElement().setIdAttributeNode(attribute, true);
            } else if (attribute.getLocalName().equals(NOT_CHANGED_SINCE)) {
                this.setNotChangedSince(OpenLibertyHelpers.dateTimeForString(attribute.getValue()), abstractXMLObject);
            } else if (attribute.getLocalName().equals(OVERRIDE_ALLOWED)) {
                this.setOverrideAllowed(OpenLibertyHelpers.booleanFromString(attribute.getValue()), abstractXMLObject);
            } else if (attribute.getLocalName().equals(ITEM_ID)) {
                this.setItemID(attribute.getValue(), abstractXMLObject);
            } else {
                return false;
            }
        }
        return true;
    }

    public void setNotChangedSince(DateTime notChangedSince, AbstractXMLObject abstractXMLObject) {
        this.notChangedSince = OpenLibertyHelpers.prepareForAssignment(this.notChangedSince, notChangedSince, OpenLibertyHelpers.getDefaultDateFormatter(), abstractXMLObject);
    }

    public DateTime getNotChangedSince() {
        return this.notChangedSince;
    }

    public void setOverrideAllowed(Boolean overrideAllowed, AbstractXMLObject abstractXMLObject) {
        this.overrideAllowed = OpenLibertyHelpers.prepareForAssignment(this.overrideAllowed, overrideAllowed, abstractXMLObject);
    }

    public Boolean getOverrideAllowed() {
        return this.overrideAllowed;
    }

    public void setId(String id, AbstractXMLObject abstractXMLObject) {
        this.id = OpenLibertyHelpers.prepareForAssignment(this.id, id, abstractXMLObject);
    }

    public String getId() {
        return this.id;
    }

    public void setItemID(String itemID, AbstractXMLObject abstractXMLObject) {
        this.itemID = OpenLibertyHelpers.prepareForAssignment(this.itemID, itemID, abstractXMLObject);
    }

    public String getItemID() {
        return this.itemID;
    }
}

