/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.wsc;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.openliberty.wsc.AuthenticationService;
import org.openliberty.wsc.BaseServiceClient;
import org.openliberty.wsc.DiscoveryService;
import org.openliberty.wsc.OpenLibertyBootstrap;
import org.openliberty.wsc.WSCException;
import org.openliberty.wsc.WSCNoServiceAvailableException;
import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.disco.RequestedService;
import org.openliberty.xmltooling.wsa.Address;
import org.openliberty.xmltooling.wsa.EndpointReference;
import org.openliberty.xmltooling.wsa.Metadata;

public class WSCUtilities {
    public static BaseServiceClient clientForDiscoveryEPR(EndpointReference discoEPR, DiscoveryService.WSFServiceType serviceType) throws WSCException {
        if (null == discoEPR) {
            throw new NullPointerException("discoEPR may not be null");
        }
        if (null == serviceType) {
            throw new NullPointerException("serviceType may not be null");
        }
        DiscoveryService discoveryService = new DiscoveryService(null, discoEPR);
        RequestedService requestedService = DiscoveryService.baseRequestedService();
        DiscoveryService.addServiceTypesToRequestedService(new String[]{serviceType.getUrn()}, requestedService);
        discoveryService.addARequestedService(requestedService);
        List<EndpointReference> eprs = discoveryService.invoke();
        if (null != eprs && eprs.size() > 0) {
            EndpointReference endpointReference = eprs.get(0);
            Metadata metadata = endpointReference.getMetadata();
            if (null == metadata) {
                throw new WSCException("The EndpointReference contains not Metadata element.  While this is not illegal, there is no way for the Utility to determine whether or not there is a valid Service as requested available in the ID-WSF2.0 environment.");
            }
            if (metadata.referencesServiceTypeURN(serviceType.getUrn())) {
                return DiscoveryService.serviceClientForTypeAndEndpointReference(discoveryService, serviceType, endpointReference);
            }
        }
        throw WSCNoServiceAvailableException.exceptionForRequestedService(requestedService);
    }

    public static BaseServiceClient clientForDiscoveryEPR(EndpointReference discoEPR, DiscoveryService.WSFServiceType serviceType, Konstantz.WSFSecurityMechanism sechMech) throws WSCException {
        if (null == discoEPR) {
            throw new NullPointerException("discoEPR may not be null");
        }
        if (null == serviceType) {
            throw new NullPointerException("serviceType may not be null");
        }
        DiscoveryService discoveryService = new DiscoveryService(null, discoEPR);
        RequestedService requestedService = DiscoveryService.baseRequestedService();
        DiscoveryService.addServiceTypesToRequestedService(new String[]{serviceType.getUrn()}, requestedService);
        if (null != sechMech) {
            DiscoveryService.addSecurityMechIDsToRequestedService(new String[]{sechMech.getUri()}, requestedService);
        }
        discoveryService.addARequestedService(requestedService);
        List<EndpointReference> eprs = discoveryService.invoke();
        if (null != eprs && eprs.size() > 0) {
            EndpointReference endpointReference = eprs.get(0);
            Metadata metadata = endpointReference.getMetadata();
            if (null == metadata) {
                throw new WSCException("The EndpointReference contains not Metadata element.  While this is not illegal, there is no way for the Utility to determine whether or not there is a valid Service as requested available in the ID-WSF2.0 environment.");
            }
            if (metadata.referencesServiceTypeURN(serviceType.getUrn())) {
                return DiscoveryService.serviceClientForTypeAndEndpointReference(discoveryService, serviceType, endpointReference);
            }
        }
        throw WSCNoServiceAvailableException.exceptionForRequestedService(requestedService);
    }

    public static EndpointReference boostrapDiscoveryEPRFromDefaultAS(AuthenticationService.AuthMechanism authMechanism) throws WSCException {
        if (null == authMechanism) {
            throw new NullPointerException("authMechanism is a required parameter and must not be null");
        }
        URL authServiceURL = null;
        try {
            authServiceURL = new URL(OpenLibertyBootstrap.getAuthenticationServiceUrl());
        }
        catch (MalformedURLException e1) {
            throw new WSCException("Default AS url '" + OpenLibertyBootstrap.getAuthenticationServiceUrl() + "' is malformed");
        }
        Address address = new Address();
        address.setValue(authServiceURL.toString());
        EndpointReference authEpr = new EndpointReference();
        authEpr.setAddress(address);
        AuthenticationService authService = AuthenticationService.serviceForEndpointReference(null, authEpr);
        return authService.authenticate(OpenLibertyBootstrap.getAuthUsername(), OpenLibertyBootstrap.getAuthPassword(), authMechanism);
    }

    public static EndpointReference boostrapDiscoveryEPRFromDefaultAS(AuthenticationService.AuthMechanism authMechanism, String username, String password) throws WSCException {
        if (null == authMechanism) {
            throw new NullPointerException("authMechanism is a required parameter and must not be null");
        }
        URL authServiceURL = null;
        try {
            authServiceURL = new URL(OpenLibertyBootstrap.getAuthenticationServiceUrl());
        }
        catch (MalformedURLException e1) {
            throw new WSCException("Default AS url '" + OpenLibertyBootstrap.getAuthenticationServiceUrl() + "' is malformed");
        }
        Address address = new Address();
        address.setValue(authServiceURL.toString());
        EndpointReference authEpr = new EndpointReference();
        authEpr.setAddress(address);
        AuthenticationService authService = AuthenticationService.serviceForEndpointReference(null, authEpr);
        return authService.authenticate(username, password, authMechanism);
    }

    public static List<EndpointReference> queryDiscoveryServiceForServiceEPRs(DiscoveryService discoService, DiscoveryService.WSFServiceType type, Konstantz.WSFSecurityMechanism mechanism) {
        String[] stringArray;
        String[] serviceTypes;
        String[] stringArray2;
        if (type != null) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = type.getUrn();
        } else {
            stringArray2 = serviceTypes = null;
        }
        if (mechanism != null) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = mechanism.getUri();
        } else {
            stringArray = null;
        }
        String[] securityMechanisms = stringArray;
        return WSCUtilities.queryDiscoveryServiceForServiceEPRs(discoService, serviceTypes, null, securityMechanisms);
    }

    public static List<EndpointReference> queryDiscoveryServiceForServiceEPRs(DiscoveryService discoService, String[] serviceTypes, String[] providerIDs, String[] securityMechIDs) {
        RequestedService requestedService = null;
        if (null != serviceTypes) {
            requestedService = DiscoveryService.requestedServiceForServiceTypes(serviceTypes);
        }
        if (null != providerIDs) {
            if (null == requestedService) {
                requestedService = DiscoveryService.requestedServiceForProviderIDs(providerIDs);
            } else {
                DiscoveryService.addProviderIDsToRequestedService(providerIDs, requestedService);
            }
        }
        if (null != securityMechIDs) {
            if (null == requestedService) {
                requestedService = DiscoveryService.requestedServiceForSecurityMechIDs(securityMechIDs);
            } else {
                DiscoveryService.addSecurityMechIDsToRequestedService(securityMechIDs, requestedService);
            }
        }
        if (null != requestedService) {
            discoService.addARequestedService(requestedService);
        }
        return discoService.invoke();
    }
}

