/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.wsc;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.openliberty.wsc.BaseServiceClient;
import org.openliberty.wsc.DiscoveryService;
import org.openliberty.wsc.WSFMessage;
import org.openliberty.xmltooling.ps.DisplayName;
import org.openliberty.xmltooling.ps.ObjectID;
import org.openliberty.xmltooling.ps.PSObject;
import org.openliberty.xmltooling.ps.TargetObjectID;
import org.openliberty.xmltooling.ps.request.AddCollectionRequest;
import org.openliberty.xmltooling.ps.request.AddEntityRequest;
import org.openliberty.xmltooling.ps.request.AddKnownEntityRequest;
import org.openliberty.xmltooling.ps.request.AddToCollectionRequest;
import org.openliberty.xmltooling.ps.request.CreatePSObject;
import org.openliberty.xmltooling.ps.request.Filter;
import org.openliberty.xmltooling.ps.request.GetObjectInfoRequest;
import org.openliberty.xmltooling.ps.request.ListMembersRequest;
import org.openliberty.xmltooling.ps.request.PStoSPRedirectURL;
import org.openliberty.xmltooling.ps.request.QueryObjectsRequest;
import org.openliberty.xmltooling.ps.request.RemoveCollectionRequest;
import org.openliberty.xmltooling.ps.request.RemoveEntityRequest;
import org.openliberty.xmltooling.ps.request.RemoveFromCollectionRequest;
import org.openliberty.xmltooling.ps.request.RequestAbstractType;
import org.openliberty.xmltooling.ps.request.ResolveIdentifierRequest;
import org.openliberty.xmltooling.ps.request.ResolveInput;
import org.openliberty.xmltooling.ps.request.SetObjectInfoRequest;
import org.openliberty.xmltooling.ps.request.Subscription;
import org.openliberty.xmltooling.ps.request.TestMembershipRequest;
import org.openliberty.xmltooling.ps.response.AddCollectionResponse;
import org.openliberty.xmltooling.ps.response.AddEntityResponse;
import org.openliberty.xmltooling.ps.response.AddKnownEntityResponse;
import org.openliberty.xmltooling.ps.response.AddToCollectionResponse;
import org.openliberty.xmltooling.ps.response.GetObjectInfoResponse;
import org.openliberty.xmltooling.ps.response.ListMembersResponse;
import org.openliberty.xmltooling.ps.response.QueryObjectsResponse;
import org.openliberty.xmltooling.ps.response.RemoveCollectionResponse;
import org.openliberty.xmltooling.ps.response.RemoveEntityResponse;
import org.openliberty.xmltooling.ps.response.RemoveFromCollectionResponse;
import org.openliberty.xmltooling.ps.response.ResolveIdentifierResponse;
import org.openliberty.xmltooling.ps.response.ResolveOutput;
import org.openliberty.xmltooling.ps.response.ResponseAbstractType;
import org.openliberty.xmltooling.ps.response.SetObjectInfoResponse;
import org.openliberty.xmltooling.ps.response.TestMembershipResponse;
import org.openliberty.xmltooling.security.Token;
import org.openliberty.xmltooling.security.TokenPolicy;
import org.openliberty.xmltooling.soap.soap11.BodyBuilder;
import org.openliberty.xmltooling.utility_2_0.Status;
import org.openliberty.xmltooling.wsa.EndpointReference;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.soap.soap11.Body;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeopleService
extends BaseServiceClient {
    protected Logger log = LoggerFactory.getLogger(PeopleService.class);
    public static final String SERVICE_URN = "urn:liberty:ps:2006-08";

    public PeopleService(DiscoveryService discoveryService, EndpointReference initialEndpointReference) {
        super(discoveryService, initialEndpointReference);
    }

    public static PeopleService peopleServiceForEndpointReference(DiscoveryService discoveryService, EndpointReference epr) {
        PeopleService ps = new PeopleService(discoveryService, epr);
        return ps;
    }

    public AddEntityResponse addEntity(PSObject entity) {
        return this.addEntity(entity, null, null, null, false);
    }

    public AddEntityResponse addEntity(PSObject entity, Subscription subscription, TokenPolicy policy, PStoSPRedirectURL pStoSPRedirectURL, boolean createReciprocalPSObject) {
        if (entity.getNodeType() != PSObject.NodeType.ENTITY) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("addEntity cannot be used to add a collection.  The PSObject provided must have a NodeType of ENTITY");
            }
            return null;
        }
        XMLObjectChildrenList<DisplayName> displayNames = entity.getDisplayNames();
        if (displayNames.size() < 1) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cannot add an entity that does not contain at least one display name");
            }
            return null;
        }
        for (DisplayName displayName : displayNames) {
            String value = displayName.getValue();
            if (value == null || value.trim().length() == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("DisplayName requires a value, this entity cannot be created while containing an empty DisplayName value");
                }
                return null;
            }
            String locale = displayName.getLocale();
            if (locale != null && locale.trim().length() != 0) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("DisplayName requires a locale, this entity cannot be created while containing an unspecified locale");
            }
            return null;
        }
        if (null != policy && null == subscription) {
            return null;
        }
        AddEntityRequest request = new AddEntityRequest();
        request.setObject(entity);
        if (null != subscription) {
            request.setSubscription(subscription);
        }
        if (null != pStoSPRedirectURL) {
            request.setPStoSPRedirectURL(pStoSPRedirectURL);
        }
        if (createReciprocalPSObject) {
            CreatePSObject createPSObject = new CreatePSObject();
            request.setCreatePSObject(createPSObject);
        }
        if (null != policy) {
            request.setTokenPolicy(policy);
        }
        return (AddEntityResponse)this.invoke(request);
    }

    public AddKnownEntityResponse addKnownEntity(PSObject entity, Token token) {
        return this.addKnownEntity(entity, token, null, null, null, false);
    }

    public AddKnownEntityResponse addKnownEntity(PSObject entity, Token token, Subscription subscription, TokenPolicy policy, PStoSPRedirectURL pStoSPRedirectURL, boolean createReciprocalPSObject) {
        if (entity.getNodeType() != PSObject.NodeType.ENTITY) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("addKnownEntity cannot be used to add a collection.  The PSObject provided must have a NodeType of ENTITY");
            }
            return null;
        }
        XMLObjectChildrenList<DisplayName> displayNames = entity.getDisplayNames();
        if (displayNames.size() < 1) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cannot add an entity that does not contain at least one display name");
            }
            return null;
        }
        for (DisplayName displayName : displayNames) {
            String value = displayName.getValue();
            if (value == null || value.trim().length() == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("DisplayName requires a value, this entity cannot be created while containing an empty DisplayName value");
                }
                return null;
            }
            String locale = displayName.getLocale();
            if (locale != null && locale.trim().length() != 0) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("DisplayName requires a locale, this entity cannot be created while containing an unspecified locale");
            }
            return null;
        }
        if (null != policy && null == subscription) {
            return null;
        }
        AddKnownEntityRequest request = new AddKnownEntityRequest(entity, token);
        if (null != subscription) {
            request.setSubscription(subscription);
        }
        if (createReciprocalPSObject) {
            CreatePSObject createPSObject = new CreatePSObject();
            request.setCreatePSObject(createPSObject);
        }
        if (null != policy) {
            request.setTokenPolicy(policy);
        }
        return (AddKnownEntityResponse)this.invoke(request);
    }

    public RemoveEntityResponse removeEntities(List<PSObject> entities) {
        if (null == entities) {
            return null;
        }
        ArrayList<TargetObjectID> targetIDs = new ArrayList<TargetObjectID>(entities.size());
        for (PSObject anEntity : entities) {
            if (anEntity.getNodeType() == PSObject.NodeType.ENTITY) {
                TargetObjectID targetID = anEntity.createTargetObjectID();
                if (null != targetID) {
                    targetIDs.add(targetID);
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("PSObject '" + anEntity.getName() + "' has no objectId and therefore will not be removed using removeEntities.");
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("PSObject '" + anEntity.getName() + "' cannot be removed using removeEntities, since it is a collection");
        }
        return this.removeEntitiesWithTargetObjectIds(targetIDs);
    }

    public RemoveEntityResponse removeEntitiesWithIds(List<String> entityIds) {
        if (null == entityIds) {
            return null;
        }
        ArrayList<TargetObjectID> targetIDs = new ArrayList<TargetObjectID>(entityIds.size());
        for (String anEntityId : entityIds) {
            TargetObjectID targetID = new TargetObjectID(anEntityId);
            if (null == targetID) continue;
            targetIDs.add(targetID);
        }
        return this.removeEntitiesWithTargetObjectIds(targetIDs);
    }

    public RemoveEntityResponse removeEntityWithTargetObjectID(TargetObjectID id) {
        ArrayList<TargetObjectID> targetObjectIDs = new ArrayList<TargetObjectID>();
        targetObjectIDs.add(id);
        return this.removeEntitiesWithTargetObjectIds(targetObjectIDs);
    }

    public RemoveEntityResponse removeEntitiesWithTargetObjectIds(List<TargetObjectID> targetObjectIDs) {
        RemoveEntityRequest request = new RemoveEntityRequest();
        request.getTargetObjectIDs().addAll(targetObjectIDs);
        return (RemoveEntityResponse)this.invoke(request);
    }

    public TestMembershipResponse testMembership(Token identityToken, TargetObjectID collection, Subscription subscription) {
        if (null == identityToken) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Null values for the following parameters are not valid when testing membership in a collection: identityToken (" + identityToken + ").");
            }
            return null;
        }
        TestMembershipRequest request = new TestMembershipRequest(identityToken);
        if (null != collection) {
            request.setTargetObjectID(collection);
        }
        if (null != subscription) {
            request.setSubscription(subscription);
        }
        return (TestMembershipResponse)this.invoke(request);
    }

    public AddCollectionResponse addCollection(PSObject collection, Subscription subscription) {
        if (!collection.isCollection()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("The PSObject specified in addCollection must be a collection");
            }
            return null;
        }
        XMLObjectChildrenList<DisplayName> displayNames = collection.getDisplayNames();
        if (displayNames.size() < 1) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cannot add an collection that does not contain at least one display name");
            }
            return null;
        }
        for (DisplayName displayName : displayNames) {
            String value = displayName.getValue();
            if (value == null || value.trim().length() == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("DisplayName requires a value, this collection cannot be created while containing an empty DisplayName value");
                }
                return null;
            }
            String locale = displayName.getLocale();
            if (locale != null && locale.trim().length() != 0) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("DisplayName requires a locale, this collection cannot be created while containing an unspecified locale");
            }
            return null;
        }
        AddCollectionRequest request = new AddCollectionRequest();
        request.setObject(collection);
        if (null != subscription) {
            request.setSubscription(subscription);
        }
        return (AddCollectionResponse)this.invoke(request);
    }

    public RemoveCollectionResponse removeCollections(List<PSObject> collections) {
        if (null == collections) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("collections must contain Collection PSObjects");
            }
            return null;
        }
        ArrayList<TargetObjectID> targetIDs = new ArrayList<TargetObjectID>(collections.size());
        for (PSObject aCollection : collections) {
            if (aCollection.isCollection()) {
                TargetObjectID targetID = aCollection.createTargetObjectID();
                if (null != targetID) {
                    targetIDs.add(targetID);
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("The PSObject " + aCollection.getName() + " has no object id and cannot be removed");
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("The PSObject " + aCollection.getName() + " is not a collection");
        }
        return this.removeCollectionsForTargetIDs(targetIDs);
    }

    public RemoveCollectionResponse removeCollectionForTargetObjectID(TargetObjectID id) {
        ArrayList<TargetObjectID> targetCollectionIDs = new ArrayList<TargetObjectID>();
        targetCollectionIDs.add(id);
        return this.removeCollectionsForTargetIDs(targetCollectionIDs);
    }

    public RemoveCollectionResponse removeCollectionsForTargetIDs(List<TargetObjectID> targetIDs) {
        RemoveCollectionRequest request = new RemoveCollectionRequest();
        request.getTargetObjectIDs().addAll(targetIDs);
        return (RemoveCollectionResponse)this.invoke(request);
    }

    public AddToCollectionResponse addObjectsToCollection(List<ObjectID> objectIDs, TargetObjectID collectionID, Subscription subscription) {
        if (null == collectionID) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("The ObjectID of the target collection is required");
            }
            return null;
        }
        if (null == objectIDs || objectIDs.size() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("1 to N ObjectID objects must be specified");
            }
            return null;
        }
        AddToCollectionRequest request = new AddToCollectionRequest(collectionID, objectIDs);
        if (null != subscription) {
            request.setSubscription(subscription);
        }
        return (AddToCollectionResponse)this.invoke(request);
    }

    public RemoveFromCollectionResponse removeObjectsFromCollection(List<ObjectID> objectIDs, TargetObjectID collectionID, Subscription subscription) {
        if (null == collectionID) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("The ObjectID of the target collection is required");
            }
            return null;
        }
        if (null == objectIDs || objectIDs.size() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("1 to N ObjectID objects must be specified");
            }
            return null;
        }
        RemoveFromCollectionRequest request = new RemoveFromCollectionRequest(collectionID, objectIDs);
        if (null != subscription) {
            request.setSubscription(subscription);
        }
        return (RemoveFromCollectionResponse)this.invoke(request);
    }

    public ListMembersResponse listCollectionMembers(TargetObjectID collectionID, ListStructure structure, Integer count, Integer offset, Subscription subscription) {
        if (offset != 0 && subscription != null && this.log.isDebugEnabled()) {
            this.log.debug("The WSC SHOULD NOT include a <Subscription> element in a <ListMembersRequest> message if the Offset attribute has any value other than \"0.\"");
        }
        ListMembersRequest request = new ListMembersRequest();
        request.setStructured(structure.name());
        request.setCount((int)count);
        request.setOffset((int)offset);
        if (null != collectionID) {
            request.setTargetObjectID(collectionID);
        }
        if (null != subscription) {
            request.setSubscription(subscription);
        }
        return (ListMembersResponse)this.invoke(request);
    }

    public PSObject getObjectInfo(TargetObjectID targetObjectID, Subscription subscription) {
        GetObjectInfoResponse response;
        if (null != targetObjectID) {
            String id = targetObjectID.getURI();
            if (null == id || id.length() == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("targetObjectID is required for A GetObjectInfo request");
                }
                return null;
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("targetObjectID is required for A GetObjectInfo request");
            }
            return null;
        }
        GetObjectInfoRequest request = new GetObjectInfoRequest(targetObjectID);
        if (null != subscription) {
            request.setSubscription(subscription);
        }
        if (null != (response = (GetObjectInfoResponse)this.invoke(request))) {
            Status status = response.getStatus();
            if (this.log.isDebugEnabled()) {
                this.log.debug("GetObjectInfoResponse Status: " + status.getCode());
            }
            if (status.isOK()) {
                return response.getObject();
            }
        }
        return null;
    }

    public SetObjectInfoResponse updateObjects(List<PSObject> objects, Subscription subscription) {
        SetObjectInfoRequest request = new SetObjectInfoRequest(objects);
        if (null != subscription) {
            request.setSubscription(subscription);
        }
        return (SetObjectInfoResponse)this.invoke(request);
    }

    public SetObjectInfoResponse setObjectInfo(List<PSObject> objects, Subscription subscription) {
        return this.updateObjects(objects, subscription);
    }

    public List<ResolveOutput> resolveIdentifiers(List<ResolveInput> inputs) {
        ResolveIdentifierRequest request = new ResolveIdentifierRequest();
        request.getResolveInputs().addAll(inputs);
        ResolveIdentifierResponse response = (ResolveIdentifierResponse)this.invoke(request);
        return response != null ? response.getResolveOutputs() : null;
    }

    public List<PSObject> queryObjects(String pathExpression, int count, int offset, Subscription subscription) {
        Filter filter = new Filter(pathExpression);
        if (!filter.getPathExpression().equals(pathExpression)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("pathExpression \"" + pathExpression + "\" appears to be invalid.");
            }
            return null;
        }
        QueryObjectsRequest request = new QueryObjectsRequest(filter);
        if (null != subscription) {
            request.setSubscription(subscription);
        }
        if (count < 0) {
            count = 0;
        }
        request.setCount(count);
        if (offset < 0) {
            offset = 0;
        }
        request.setOffset(offset);
        QueryObjectsResponse response = (QueryObjectsResponse)this.invoke(request);
        return null != response ? response.getObjects() : null;
    }

    private ResponseAbstractType invoke(RequestAbstractType request) {
        WSFMessage message = null;
        try {
            message = WSFMessage.createWSFMessage(this, request.type().actionURI());
            Body requestBody = new BodyBuilder().buildObject();
            requestBody.getUnknownXMLObjects().add(request);
            message.getRequestEnvelope().setBody(requestBody);
            try {
                message.invoke();
                Body responseBody = message.getResponseEnvelope().getBody();
                for (XMLObject object : responseBody.getUnknownXMLObjects()) {
                    if (!request.type().responseClass().isInstance(object)) continue;
                    return (ResponseAbstractType)object;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("No " + request.type().responseClass().getName() + " element found in the body of the response Envelope");
                }
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.error("Exception while attempting to invoke a WSFMessage", (Throwable)e);
                }
            }
        }
        catch (XMLParserException e1) {
            e1.printStackTrace();
        }
        catch (UnmarshallingException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public static enum ListStructure {
        children,
        tree,
        entities;

    }
}

