/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.wsc;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.openliberty.wsc.AuthenticationService;
import org.openliberty.wsc.BaseServiceClient;
import org.openliberty.wsc.DirectoryAccessProtocolService;
import org.openliberty.wsc.PeopleService;
import org.openliberty.wsc.PersonalProfileService;
import org.openliberty.wsc.WSFMessage;
import org.openliberty.xmltooling.disco.DiscoQuery;
import org.openliberty.xmltooling.disco.DiscoQueryBuilder;
import org.openliberty.xmltooling.disco.DiscoQueryResponse;
import org.openliberty.xmltooling.disco.ProviderID;
import org.openliberty.xmltooling.disco.RequestedService;
import org.openliberty.xmltooling.disco.RequestedServiceBuilder;
import org.openliberty.xmltooling.disco.SecurityMechID;
import org.openliberty.xmltooling.disco.ServiceType;
import org.openliberty.xmltooling.soap.soap11.BodyBuilder;
import org.openliberty.xmltooling.soapbinding.Framework;
import org.openliberty.xmltooling.wsa.EndpointReference;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryService
extends BaseServiceClient {
    protected Logger log = LoggerFactory.getLogger(DiscoveryService.class);
    private static final String IDWSF_20_PERSONAL_PROFILE_SERVICE_URN = "urn:liberty:id-sis-pp:2005-05";
    private static final String IDWSF_20_PEOPLE_SERVICE_URN = "urn:liberty:ps:2006-08";
    private static final String IDWSF_20_AUTHENTICATION_SERVICE_URN = "urn:liberty:sa:2006-08";
    private static final String IDWSF_20_DISCOVERY_SERVICE_URN = "urn:liberty:disco:2006-08";
    private static final String IDWSF_20_ID_SIS_DAP_SERVICE_URN = "urn:liberty:id-sis-dap:2006-02:dst-2.1";
    public static final String DISCO_QUERY = "urn:liberty:disco:2006-08:Query";
    private List<RequestedService> requestedServices;

    public DiscoveryService(EndpointReference initialEndpointReference) {
        super(null, initialEndpointReference);
    }

    public DiscoveryService(DiscoveryService discoveryService, EndpointReference initialEndpointReference) {
        super(discoveryService, initialEndpointReference);
    }

    public static RequestedService requestedServiceForServiceTypes(String[] serviceTypes) {
        RequestedService requestedService = null;
        if (null != serviceTypes && serviceTypes.length > 0) {
            requestedService = DiscoveryService.baseRequestedService();
            DiscoveryService.addServiceTypesToRequestedService(serviceTypes, requestedService);
        }
        return requestedService;
    }

    public static void addServiceTypesToRequestedService(String[] serviceTypes, RequestedService requestedService) {
        for (int t = 0; t < serviceTypes.length; ++t) {
            ServiceType serviceType = new ServiceType();
            serviceType.setValue(serviceTypes[t]);
            requestedService.getServiceTypes().add((Object)serviceType);
        }
    }

    public static RequestedService requestedServiceForProviderIDs(String[] providerIDs) {
        RequestedService requestedService = null;
        if (null != providerIDs && providerIDs.length > 0) {
            requestedService = DiscoveryService.baseRequestedService();
            DiscoveryService.addProviderIDsToRequestedService(providerIDs, requestedService);
        }
        return requestedService;
    }

    public static void addProviderIDsToRequestedService(String[] providerIDs, RequestedService requestedService) {
        for (int t = 0; t < providerIDs.length; ++t) {
            ProviderID providerID = new ProviderID();
            providerID.setValue(providerIDs[t]);
            requestedService.getProviderIDs().add((Object)providerID);
        }
    }

    public static RequestedService requestedServiceForSecurityMechIDs(String[] securityMechIDs) {
        RequestedService requestedService = null;
        if (null != securityMechIDs && securityMechIDs.length > 0) {
            requestedService = DiscoveryService.baseRequestedService();
            DiscoveryService.addSecurityMechIDsToRequestedService(securityMechIDs, requestedService);
        }
        return requestedService;
    }

    public static void addSecurityMechIDsToRequestedService(String[] securityMechIDs, RequestedService requestedService) {
        for (int t = 0; t < securityMechIDs.length; ++t) {
            SecurityMechID securityMechID = new SecurityMechID();
            securityMechID.setValue(securityMechIDs[t]);
            requestedService.getSecurityMechIDs().add((Object)securityMechID);
        }
    }

    public static RequestedService baseRequestedService() {
        RequestedServiceBuilder requestedServiceBuilder = new RequestedServiceBuilder();
        RequestedService requestedService = requestedServiceBuilder.buildObject();
        Framework framework = new Framework();
        framework.setVersion("2.0");
        requestedService.getFrameworks().add((Object)framework);
        return requestedService;
    }

    public void addARequestedService(RequestedService requestedService) {
        if (null == this.requestedServices) {
            this.requestedServices = new ArrayList<RequestedService>();
        }
        this.requestedServices.add(requestedService);
    }

    public void clearRequestedServices() {
        this.requestedServices = new ArrayList<RequestedService>();
    }

    public List<EndpointReference> invoke() {
        List<EndpointReference> discoveredEPRs = null;
        WSFMessage wsfMessage = null;
        try {
            wsfMessage = WSFMessage.createWSFMessage(this, DISCO_QUERY);
            BodyBuilder bodyBuilder = new BodyBuilder();
            Body body = bodyBuilder.buildObject();
            DiscoQueryBuilder discoQueryBuilder = new DiscoQueryBuilder();
            DiscoQuery discoQuery = discoQueryBuilder.buildObject();
            if (this.requestedServices == null) {
                this.requestedServices = new ArrayList<RequestedService>();
                this.requestedServices.add(DiscoveryService.baseRequestedService());
            }
            for (RequestedService requestedService : this.requestedServices) {
                discoQuery.getRequestedServices().add((Object)requestedService);
            }
            body.getUnknownXMLObjects().add(discoQuery);
            wsfMessage.getRequestEnvelope().setBody(body);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Disco Request: " + WSFMessage.prettyPrintRequestMessage(wsfMessage));
            }
            try {
                wsfMessage.invoke();
                discoveredEPRs = DiscoveryService.eprsFromDiscoResponse(wsfMessage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Disco Response: " + WSFMessage.prettyPrintResponseMessage(wsfMessage));
            }
        }
        catch (XMLParserException e1) {
            e1.printStackTrace();
        }
        catch (UnmarshallingException e1) {
            e1.printStackTrace();
        }
        this.clearRequestedServices();
        return discoveredEPRs;
    }

    public static List<EndpointReference> eprsFromDiscoResponse(WSFMessage message) {
        Envelope discoResponse = message.getResponseEnvelope();
        if (null != discoResponse) {
            Body body = discoResponse.getBody();
            List kids = body.getOrderedChildren();
            for (XMLObject kid : kids) {
                if (!(kid instanceof DiscoQueryResponse)) continue;
                return ((DiscoQueryResponse)kid).getEndpointReferences();
            }
        }
        return null;
    }

    public BaseServiceClient serviceClientForTypeAndEndpointReference(WSFServiceType serviceType, EndpointReference endpointReference) {
        return DiscoveryService.serviceClientForTypeAndEndpointReference(this, serviceType, endpointReference);
    }

    public static BaseServiceClient serviceClientForTypeAndEndpointReference(DiscoveryService discoveryService, WSFServiceType serviceType, EndpointReference endpointReference) {
        if (serviceType == WSFServiceType.AUTHENTICATION_SERVICE) {
            return new AuthenticationService(discoveryService, endpointReference);
        }
        if (serviceType == WSFServiceType.DISCOVERY_SERVICE) {
            return new DiscoveryService(discoveryService, endpointReference);
        }
        if (serviceType == WSFServiceType.DIRECTORY_ACCESS_PROTOCOL_SERVICE) {
            return new DirectoryAccessProtocolService(discoveryService, endpointReference);
        }
        if (serviceType == WSFServiceType.PERSONAL_PROFILE_SERVICE) {
            return new PersonalProfileService(discoveryService, endpointReference);
        }
        if (serviceType == WSFServiceType.PEOPLE_SERVICE) {
            return new PeopleService(discoveryService, endpointReference);
        }
        return null;
    }

    public static enum WSFServiceType {
        AUTHENTICATION_SERVICE("urn:liberty:sa:2006-08"),
        DISCOVERY_SERVICE("urn:liberty:disco:2006-08"),
        PERSONAL_PROFILE_SERVICE("urn:liberty:id-sis-pp:2005-05"),
        PEOPLE_SERVICE("urn:liberty:ps:2006-08"),
        DIRECTORY_ACCESS_PROTOCOL_SERVICE("urn:liberty:id-sis-dap:2006-02:dst-2.1");

        private String urn;

        private WSFServiceType(String urn) {
            this.urn = urn;
        }

        public static WSFServiceType serviceForUrn(String urn) {
            if (null != urn) {
                for (WSFServiceType service : WSFServiceType.values()) {
                    if (!service.getUrn().equals(urn)) continue;
                    return service;
                }
            }
            return null;
        }

        public String getUrn() {
            return this.urn;
        }
    }
}

