/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.wsc;

import java.net.URL;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.openliberty.wsc.AuthenticationService;
import org.openliberty.wsc.BaseServiceClient;
import org.openliberty.wsc.DiscoveryService;
import org.openliberty.wsc.WSCException;
import org.openliberty.wsc.WSFMessage;
import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.disco.SecurityContext;
import org.openliberty.xmltooling.disco.SecurityMechID;
import org.openliberty.xmltooling.wsa.Address;
import org.openliberty.xmltooling.wsa.EndpointReference;
import org.openliberty.xmltooling.wsa.Metadata;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseServiceClientImpl
extends BaseServiceClient {
    private Logger log = LoggerFactory.getLogger(BaseServiceClientImpl.class);

    public BaseServiceClientImpl() {
        super(null, null);
    }

    public BaseServiceClientImpl(DiscoveryService discoveryService, EndpointReference initialEndpointReference) {
        super(discoveryService, initialEndpointReference);
    }

    public Envelope invoke(XMLObject bodyChild, URL invocationURL, String actionURI) throws WSCException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(invocationURL + " " + actionURI);
        }
        Address address = new Address();
        address.setValue(invocationURL.toString());
        Metadata metadata = new Metadata();
        SecurityContext sc = new SecurityContext();
        metadata.getSecurityContexts().add((Object)sc);
        SecurityMechID securityMechID = new SecurityMechID();
        securityMechID.setValue(Konstantz.WSFSecurityMechanism.ID_WSF20_NULL_NULL.getUri());
        sc.getSecurityMechIDs().add(securityMechID);
        EndpointReference epr = new EndpointReference();
        epr.setAddress(address);
        epr.setMetadata(metadata);
        this.setServiceEndpointReference(epr);
        WSFMessage message = null;
        try {
            message = WSFMessage.createWSFMessage(this, actionURI);
        }
        catch (XMLParserException e1) {
            e1.printStackTrace();
            return null;
        }
        catch (UnmarshallingException e1) {
            e1.printStackTrace();
            return null;
        }
        message.getRequestEnvelope().getBody().getUnknownXMLObjects().add(bodyChild);
        try {
            message.invoke();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WSCException(AuthenticationService.WSCExceptionType.AUTHENTICATION_SERVICE_INVOCATION_FAILURE.shortDesc);
        }
        return message.getResponseEnvelope();
    }
}

