/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.wsc;

import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.openliberty.wsc.DiscoveryService;
import org.openliberty.xmltooling.disco.Option;
import org.openliberty.xmltooling.disco.Options;
import org.openliberty.xmltooling.wsa.EndpointReference;
import org.openliberty.xmltooling.wsa.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseServiceClient {
    private Logger log = LoggerFactory.getLogger(BaseServiceClient.class);
    private DiscoveryService discoveryService;
    private List<EndpointReference> serviceEndpointReferenceStore;
    private boolean signingOutgoingMessages = false;

    public BaseServiceClient(DiscoveryService discoveryService, EndpointReference initialEndpointReference) {
        if (null != initialEndpointReference) {
            this.setServiceEndpointReference(initialEndpointReference);
        }
        this.discoveryService = discoveryService;
    }

    public void replaceServiceEndpointReference(EndpointReference serviceEndPointReference) {
        this.serviceEndpointReferenceStore = null;
        this.setServiceEndpointReference(serviceEndPointReference);
    }

    public void setServiceEndpointReference(EndpointReference serviceEndPointReference) {
        DateTime notOnOrAfter = serviceEndPointReference.getNotOnOrAfter();
        if (null == notOnOrAfter) {
            this.serviceEndpointReferenceStore = new ArrayList<EndpointReference>();
            this.serviceEndpointReferenceStore.add(serviceEndPointReference);
        } else {
            List<EndpointReference> eprs = this.getServiceEndpointReferenceStore();
            for (int i = 0; i < eprs.size(); ++i) {
                EndpointReference epr = eprs.get(i);
                DateTime eprNotOnOrAfter = epr.getNotOnOrAfter();
                if (null != eprNotOnOrAfter && -1 != eprNotOnOrAfter.compareTo((ReadableInstant)notOnOrAfter)) continue;
                if (i == 0) {
                    this.serviceEndpointReferenceStore = new ArrayList<EndpointReference>();
                    break;
                }
                this.serviceEndpointReferenceStore = eprs.subList(0, i - 1);
                break;
            }
            eprs.add(serviceEndPointReference);
        }
    }

    public EndpointReference getServiceEndpointReference() {
        int size;
        if (null != this.serviceEndpointReferenceStore && (size = this.serviceEndpointReferenceStore.size()) > 0) {
            return this.serviceEndpointReferenceStore.get(size - 1);
        }
        return null;
    }

    public List<EndpointReference> getServiceEndpointReferenceStore() {
        if (null == this.serviceEndpointReferenceStore) {
            this.serviceEndpointReferenceStore = new ArrayList<EndpointReference>();
        }
        return this.serviceEndpointReferenceStore;
    }

    public boolean isSigningOutgoingMessages() {
        return this.signingOutgoingMessages;
    }

    public void setSigningOutgoingMessages(boolean signingOutgoingMessages) {
        this.signingOutgoingMessages = signingOutgoingMessages;
    }

    public boolean serviceExplicitlySupportsOption(String optionUri) {
        Metadata metadata = this.getServiceEndpointReference().getMetadata();
        Options optionsElement = metadata.getOptions();
        if (null != optionsElement) {
            List<Option> options = optionsElement.getOptions();
            if (options.size() > 0) {
                for (Option option : options) {
                    if (!option.getValue().equals(optionUri)) continue;
                    this.log.debug("Option Found");
                    return true;
                }
                this.log.debug("Option not found");
            } else {
                this.log.debug("This service has explicitly advertised that there are no available Options");
            }
        } else {
            this.log.debug("No Options element in Metadata");
        }
        return false;
    }

    public DiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    public void setDiscoveryService(DiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }
}

