/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.wsa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.openliberty.xmltooling.disco.SecurityContext;
import org.openliberty.xmltooling.disco.SecurityMechID;
import org.openliberty.xmltooling.wsa.Address;
import org.openliberty.xmltooling.wsa.Metadata;
import org.openliberty.xmltooling.wsa.ReferenceParameters;
import org.opensaml.core.xml.ElementExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

public class EndpointReference
extends AbstractSignableXMLObject
implements ElementExtensibleXMLObject {
    public static String LOCAL_NAME = "EndpointReference";
    public static String ATT_NOT_ON_OR_AFTER = "notOnOrAfter";
    public static String ATT_ID = "id";
    private String id;
    private DateTime notOnOrAfter;
    private Address address;
    private Metadata metadata;
    private ReferenceParameters referenceParameters;
    private IndexedXMLObjectChildrenList<XMLObject> unknownXMLObjects = new IndexedXMLObjectChildrenList((XMLObject)this);

    public EndpointReference() {
        super("http://www.w3.org/2005/08/addressing", LOCAL_NAME, "wsa");
    }

    protected EndpointReference(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public EndpointReference freshEndpointReference() {
        return this;
    }

    public String toString() {
        return this.simplePrettyDescription();
    }

    public String simplePrettyDescription() {
        StringBuffer descBuff = new StringBuffer();
        Metadata metadata = this.getMetadata();
        if (null != metadata) {
            String abstrakt;
            if (null != metadata.getMetadataAbstract() && null != (abstrakt = metadata.getMetadataAbstract().getValue())) {
                descBuff.append(abstrakt);
            }
            if (descBuff.length() == 0) {
                if (null != this.getAddress()) {
                    descBuff.append(this.getAddress().getValue());
                } else {
                    descBuff.append(super.toString());
                }
            }
            descBuff.append(" (");
            for (SecurityContext securityContext : this.getMetadata().getSecurityContexts()) {
                for (SecurityMechID securityMechID : securityContext.getSecurityMechIDs()) {
                    descBuff.append(securityMechID.getValue()).append(" ");
                }
            }
            descBuff.append(")");
            return descBuff.toString();
        }
        if (null != this.getAddress()) {
            return this.getAddress().getValue();
        }
        return super.toString();
    }

    public List<XMLObject> getUnknownXMLObjects() {
        return this.unknownXMLObjects;
    }

    public List<XMLObject> getUnknownXMLObjects(QName typeOrName) {
        return this.unknownXMLObjects.subList(typeOrName);
    }

    public List<XMLObject> getOrderedChildren() {
        LinkedList<Object> children = new LinkedList<Object>();
        children.add((Object)this.address);
        children.add((Object)this.metadata);
        children.add((Object)this.referenceParameters);
        if (null != this.unknownXMLObjects) {
            children.addAll((Collection<Object>)this.unknownXMLObjects);
        }
        return Collections.unmodifiableList(children);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.registerOwnID(this.id, id);
        this.id = id;
    }

    public void setNotOnOrAfter(DateTime notOnOrAfter) {
        this.notOnOrAfter = (DateTime)this.prepareForAssignment(this.notOnOrAfter, notOnOrAfter);
    }

    public DateTime getNotOnOrAfter() {
        return this.notOnOrAfter;
    }

    public void setAddress(Address address) {
        this.address = (Address)this.prepareForAssignment((XMLObject)this.address, (XMLObject)address);
    }

    public Address getAddress() {
        return this.address;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = (Metadata)this.prepareForAssignment((XMLObject)this.metadata, (XMLObject)metadata);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setReferenceParameters(ReferenceParameters referenceParameters) {
        this.referenceParameters = (ReferenceParameters)this.prepareForAssignment((XMLObject)this.referenceParameters, (XMLObject)referenceParameters);
    }

    public ReferenceParameters getReferenceParameters() {
        return this.referenceParameters;
    }

    public static String[] securityMechIDStringsFromEPR(EndpointReference epr) {
        XMLObjectChildrenList<SecurityContext> securityContexts = epr.getMetadata().getSecurityContexts();
        if (null != securityContexts) {
            ArrayList<String> secMechs = new ArrayList<String>();
            for (SecurityContext securityContext : securityContexts) {
                List<SecurityMechID> securityMechIDs = securityContext.getSecurityMechIDs();
                if (null == securityMechIDs) continue;
                for (SecurityMechID securityMechID : securityMechIDs) {
                    secMechs.add(securityMechID.getValue());
                }
            }
            if (secMechs.size() > 0) {
                String[] secMechArray = new String[secMechs.size()];
                secMechs.toArray(secMechArray);
                return secMechArray;
            }
        }
        return null;
    }
}

