/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.soapbinding;

import org.openliberty.xmltooling.wsa.Address;
import org.openliberty.xmltooling.wsa.EndpointReference;
import org.openliberty.xmltooling.wsa.EndpointReferenceMarshaller;
import org.openliberty.xmltooling.wsa.EndpointReferenceUnmarshaller;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class EndpointUpdate
extends EndpointReference {
    public static final String LOCAL_NAME = "EndpointUpdate";
    private UpdateType updateType;
    public static final String ATT_UPDATE_TYPE = "updateType";
    public static final String NO_ADDRESS_CHANGE = "urn:liberty:sb:2006-08:EndpointUpdate:NoChange";

    protected EndpointUpdate() {
        super("urn:liberty:sb:2006-08", LOCAL_NAME, "sb");
    }

    protected EndpointUpdate(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public boolean isNoAddressChange() {
        Address address;
        return this.getUpdateType() == UpdateType.PARTIAL && NO_ADDRESS_CHANGE.equals((address = this.getAddress()).getValue());
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(UpdateType updateType) {
        this.updateType = (UpdateType)((Object)this.prepareForAssignment((Object)this.updateType, (Object)updateType));
    }

    public static class Builder
    extends AbstractXMLObjectBuilder<EndpointUpdate> {
        public EndpointUpdate buildObject(String namespaceURI, String localName, String namespacePrefix) {
            return new EndpointUpdate(namespaceURI, localName, namespacePrefix);
        }
    }

    public static class Marshaller
    extends EndpointReferenceMarshaller {
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
            EndpointUpdate obj = (EndpointUpdate)xmlObject;
            if (null != obj.getUpdateType()) {
                domElement.setAttributeNS(null, EndpointUpdate.ATT_UPDATE_TYPE, obj.getUpdateType().getUri());
            }
            super.marshallAttributes(xmlObject, domElement);
        }
    }

    public static class Unmarshaller
    extends EndpointReferenceUnmarshaller {
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
            EndpointUpdate obj = (EndpointUpdate)xmlObject;
            if (attribute.getLocalName().equals(EndpointUpdate.ATT_UPDATE_TYPE)) {
                obj.setUpdateType(UpdateType.getUpdateTypeForUri(attribute.getValue()));
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        }
    }

    public static enum UpdateType {
        COMPLETE("urn:liberty:sb:2006-08:EndpointUpdate:Complete"),
        PARTIAL("urn:liberty:sb:2006-08:EndpointUpdate:Partial");

        private String uri;

        private UpdateType(String uri) {
            this.uri = uri;
        }

        public static UpdateType getUpdateTypeForUri(String uri) {
            if (null != uri) {
                for (UpdateType updateType : UpdateType.values()) {
                    if (!uri.equals(updateType.uri)) continue;
                    return updateType;
                }
            }
            return null;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

