/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.ps.request;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.ps.TargetObjectID;
import org.openliberty.xmltooling.ps.request.RequestAbstractType;
import org.openliberty.xmltooling.subs.Subscription;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ListMembersRequest
extends RequestAbstractType {
    public static String LOCAL_NAME = ListMembersRequest.class.getSimpleName();
    public static int NO_COUNT = 0;
    public static int NO_OFFSET = 0;
    private String structured;
    private Integer count;
    private Integer offset;
    public static final String ATT_STRUCTURED = "Structured";
    public static final String ATT_COUNT = "Count";
    public static final String ATT_OFFSET = "Offset";
    private TargetObjectID targetObjectID;
    private Subscription subscription;

    public ListMembersRequest() {
        super("urn:liberty:ps:2006-08", LOCAL_NAME, "ps");
    }

    public ListMembersRequest(TargetObjectID targetObjectID) {
        super("urn:liberty:ps:2006-08", LOCAL_NAME, "ps");
        this.targetObjectID = targetObjectID;
    }

    protected ListMembersRequest(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public TargetObjectID getTargetObjectID() {
        return this.targetObjectID;
    }

    public void setTargetObjectID(TargetObjectID targetObjectID) {
        this.targetObjectID = (TargetObjectID)this.prepareForAssignment((XMLObject)this.targetObjectID, (XMLObject)targetObjectID);
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public void setSubscription(Subscription subscription) {
        this.subscription = (Subscription)this.prepareForAssignment((XMLObject)this.subscription, (XMLObject)subscription);
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = (Integer)this.prepareForAssignment(this.count, count);
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = (Integer)this.prepareForAssignment(this.offset, offset);
    }

    public String getStructured() {
        return this.structured;
    }

    public void setStructured(String structured) {
        this.structured = this.prepareForAssignment(this.structured, structured);
    }

    public List<XMLObject> getOrderedChildren() {
        LinkedList<Object> children = new LinkedList<Object>();
        children.add((Object)this.targetObjectID);
        children.add((Object)this.subscription);
        return Collections.unmodifiableList(children);
    }

    public static class Unmarshaller
    extends RequestAbstractType.Unmarshaller {
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
            ListMembersRequest obj = (ListMembersRequest)xmlObject;
            String attLocalName = attribute.getLocalName();
            if (attLocalName.equals(ListMembersRequest.ATT_STRUCTURED)) {
                obj.setStructured(attribute.getValue());
            } else if (attLocalName.equals(ListMembersRequest.ATT_COUNT)) {
                obj.setCount(OpenLibertyHelpers.positiveIntegerFromString(attribute.getValue(), null));
            } else if (attLocalName.equals(ListMembersRequest.ATT_OFFSET)) {
                obj.setOffset(OpenLibertyHelpers.positiveIntegerFromString(attribute.getValue(), 0));
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        }

        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
            ListMembersRequest object = (ListMembersRequest)parentXMLObject;
            if (childXMLObject instanceof TargetObjectID) {
                object.setTargetObjectID((TargetObjectID)childXMLObject);
            } else if (childXMLObject instanceof Subscription) {
                object.setSubscription((Subscription)childXMLObject);
            }
        }
    }

    public static class Marshaller
    extends RequestAbstractType.Marshaller {
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
            ListMembersRequest obj = (ListMembersRequest)xmlObject;
            if (obj.getCount() != null) {
                domElement.setAttributeNS(null, ListMembersRequest.ATT_COUNT, obj.getCount().toString());
            }
            if (obj.getOffset() != null) {
                domElement.setAttributeNS(null, ListMembersRequest.ATT_OFFSET, obj.getOffset().toString());
            }
            if (obj.getStructured() != null) {
                domElement.setAttributeNS(null, ListMembersRequest.ATT_STRUCTURED, obj.getStructured());
            }
            super.marshallAttributes(xmlObject, domElement);
        }
    }

    public static class Builder
    extends AbstractXMLObjectBuilder<ListMembersRequest> {
        public ListMembersRequest buildObject(String namespaceURI, String localName, String namespacePrefix) {
            return new ListMembersRequest(namespaceURI, localName, namespacePrefix);
        }
    }
}

