/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.wsc;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.openliberty.wsc.AuthenticationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.config.XMLConfigurationException;
import org.opensaml.core.xml.config.XMLConfigurator;

public class OpenLibertyBootstrap {
    private static Logger log = Logger.getLogger(OpenLibertyBootstrap.class);
    public static final String AUTHETICATION_SERVICE_URL_KEY = "org.openliberty.wsc.OpenLibertyBootstrap.authenticationServiceUrl";
    private static String providerIDUri;
    private static String authenticationServiceUrl;
    private static String authUsername;
    private static String authPassword;
    private static AuthenticationService.AuthMechanism authMechanism;
    private static List<X509Certificate> trustedCertificates;
    private static String defaultSigningPKSPath;
    private static String defaultSigningPKSAlias;
    private static String defaultSigningPKSPassword;
    private static String defaultClientTLSPKSPath;
    private static String defaultClientTLSPKSAlias;
    private static String defaultClientTLSPKSPassword;
    private static boolean checkHostName;
    private static boolean checkExpiry;
    private static String[] xmlToolingConfigs;

    protected OpenLibertyBootstrap() {
    }

    public static synchronized void bootstrap() throws XMLConfigurationException {
        OpenLibertyBootstrap.initializeOpenSAML();
        OpenLibertyBootstrap.initializeXMLTooling(xmlToolingConfigs);
        OpenLibertyBootstrap.initializeClientLibProperties();
    }

    private static void initializeOpenSAML() {
        try {
            InitializationService.initialize();
        }
        catch (InitializationException e) {
            log.error((Object)"Error initializing OpenSAML", (Throwable)e);
        }
    }

    public static synchronized void bootstrap(String[] additionalXmlToolingConfigs) throws XMLConfigurationException {
        String[] xmlToolingConfigsCombined = null;
        if (null != additionalXmlToolingConfigs) {
            xmlToolingConfigsCombined = new String[additionalXmlToolingConfigs.length + xmlToolingConfigs.length];
            int i = 0;
            int j = 0;
            while (j < xmlToolingConfigs.length) {
                xmlToolingConfigsCombined[i] = xmlToolingConfigs[j];
                ++j;
                ++i;
            }
            j = 0;
            while (j < additionalXmlToolingConfigs.length) {
                xmlToolingConfigsCombined[i] = additionalXmlToolingConfigs[j];
                ++j;
                ++i;
            }
        } else {
            xmlToolingConfigsCombined = xmlToolingConfigs;
        }
        OpenLibertyBootstrap.initializeXMLTooling(xmlToolingConfigsCombined);
        OpenLibertyBootstrap.initializeClientLibProperties();
    }

    protected static void initializeXMLTooling(String[] providerConfigs) throws XMLConfigurationException {
        XMLConfigurator configurator = new XMLConfigurator();
        for (String config : providerConfigs) {
            log.info((Object)("Loading XMLTooling configuration " + config));
            configurator.load(configurator.getClass().getResourceAsStream(config));
        }
    }

    protected static void initializeClientLibProperties() {
        providerIDUri = "https://z-sp.openliberty.org";
        authenticationServiceUrl = "";
        authUsername = "";
        authPassword = "";
        authMechanism = AuthenticationService.AuthMechanism.PLAIN;
        defaultSigningPKSPath = "/certs/z-sp-sign.jks";
        defaultSigningPKSAlias = "tomcat";
        defaultSigningPKSPassword = "changeit";
        defaultClientTLSPKSPath = "/certs/z-sp-ssl.jks";
        defaultClientTLSPKSAlias = "tomcat";
        defaultClientTLSPKSPassword = "changeit";
    }

    public static String getAuthenticationServiceUrl() {
        return authenticationServiceUrl;
    }

    public static String getAuthPassword() {
        return authPassword;
    }

    public static String getAuthUsername() {
        return authUsername;
    }

    public static String getProviderIDUri() {
        return providerIDUri;
    }

    public static AuthenticationService.AuthMechanism getAuthMechanism() {
        return authMechanism;
    }

    public static String getDefaultClientTLSPKSAlias() {
        return defaultClientTLSPKSAlias;
    }

    public static String getDefaultClientTLSPKSPassword() {
        return defaultClientTLSPKSPassword;
    }

    public static String getDefaultClientTLSPKSPath() {
        return defaultClientTLSPKSPath;
    }

    public static String getDefaultSigningPKSAlias() {
        return defaultSigningPKSAlias;
    }

    public static String getDefaultSigningPKSPassword() {
        return defaultSigningPKSPassword;
    }

    public static String getDefaultSigningPKSPath() {
        return defaultSigningPKSPath;
    }

    public static List<X509Certificate> getTrustedCertificates() {
        return trustedCertificates;
    }

    public static boolean isCheckHostName() {
        return checkHostName;
    }

    public static boolean isCheckExpiry() {
        return checkExpiry;
    }

    public static void setAuthenticationServiceDefaults(String authenticationServiceUrl, String authUsername, String authPassword) {
        OpenLibertyBootstrap.setAuthenticationServiceUrl(authenticationServiceUrl);
        OpenLibertyBootstrap.setAuthUsername(authUsername);
        OpenLibertyBootstrap.setAuthPassword(authPassword);
    }

    public static void setAuthenticationServiceUrl(String authenticationServiceUrl) {
        OpenLibertyBootstrap.authenticationServiceUrl = authenticationServiceUrl;
    }

    public static void setAuthPassword(String authPassword) {
        OpenLibertyBootstrap.authPassword = authPassword;
    }

    public static void setAuthUsername(String authUsername) {
        OpenLibertyBootstrap.authUsername = authUsername;
    }

    public static void setProviderIDUri(String providerIDUri) {
        OpenLibertyBootstrap.providerIDUri = providerIDUri;
    }

    public static void setAuthMechanism(AuthenticationService.AuthMechanism authMechanism) {
        OpenLibertyBootstrap.authMechanism = authMechanism;
    }

    public static void setDefaultClientTLSPKSAlias(String defaultClientTLSPKSAlias) {
        OpenLibertyBootstrap.defaultClientTLSPKSAlias = defaultClientTLSPKSAlias;
    }

    public static void setDefaultClientTLSPKSPassword(String defaultClientTLSPKSPassword) {
        OpenLibertyBootstrap.defaultClientTLSPKSPassword = defaultClientTLSPKSPassword;
    }

    public static void setDefaultClientTLSPKSPath(String defaultClientTLSPKSPath) {
        OpenLibertyBootstrap.defaultClientTLSPKSPath = defaultClientTLSPKSPath;
    }

    public static void setDefaultSigningPKSAlias(String defaultSigningPKSAlias) {
        OpenLibertyBootstrap.defaultSigningPKSAlias = defaultSigningPKSAlias;
    }

    public static void setDefaultSigningPKSPassword(String defaultSigningPKSPassword) {
        OpenLibertyBootstrap.defaultSigningPKSPassword = defaultSigningPKSPassword;
    }

    public static void setDefaultSigningPKSPath(String defaultSigningPKSPath) {
        OpenLibertyBootstrap.defaultSigningPKSPath = defaultSigningPKSPath;
    }

    public static void setCheckHostName(boolean checkHostName) {
        OpenLibertyBootstrap.checkHostName = checkHostName;
    }

    public static void setCheckExpiry(boolean checkExpiry) {
        OpenLibertyBootstrap.checkExpiry = checkExpiry;
    }

    static {
        trustedCertificates = new ArrayList<X509Certificate>();
        checkHostName = true;
        checkExpiry = true;
        xmlToolingConfigs = new String[]{"/sasl-xmltooling-config.xml", "/wsa-config.xml", "/disco-config.xml", "/lu-config.xml", "/id-sis-dap-config.xml", "/ps-config.xml", "/pp-config.xml", "/soap-binding-xmltooling-config.xml", "/openliberty-soap11-config.xml", "/sec-config.xml", "/subs-config.xml"};
    }
}

