/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.logic;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.session.LogoutPropagationFlowDescriptor;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class LogoutPropagationFlowDescriptorSelector
implements Function<SPSession, LogoutPropagationFlowDescriptor> {
    @Nonnull
    @NonnullElements
    private final List<LogoutPropagationFlowDescriptor> availableFlows;

    public LogoutPropagationFlowDescriptorSelector(@Nonnull @ParameterName(name="flows") @NonnullElements List<LogoutPropagationFlowDescriptor> flows) {
        this.availableFlows = List.copyOf((Collection)Constraint.isNotNull(flows, (String)"Flows cannot be null"));
    }

    @Override
    @Nullable
    public LogoutPropagationFlowDescriptor apply(@Nullable SPSession input) {
        for (LogoutPropagationFlowDescriptor flowDescriptor : this.availableFlows) {
            if (!flowDescriptor.getSessionType().isInstance(input)) continue;
            return flowDescriptor;
        }
        return null;
    }
}

