/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.session.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.session.SAML2SPSession;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2SPSessionCreationStrategy
implements Function<ProfileRequestContext, SPSession> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML2SPSessionCreationStrategy.class);
    @Nonnull
    private final Duration sessionLifetime;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Response> responseLookupStrategy;

    public SAML2SPSessionCreationStrategy(@Nonnull Duration lifetime) {
        this.sessionLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Lifetime cannot be null");
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
        this.responseLookupStrategy = new MessageLookup(Response.class).compose((Function)new OutboundMessageContextLookup());
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setResponseLookupStrategy(@Nonnull Function<ProfileRequestContext, Response> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public SPSession apply(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(input);
        if (rpCtx == null) {
            this.log.debug("No RelyingPartyContext, no SAML2SPSession created");
            return null;
        }
        String issuer = rpCtx.getRelyingPartyId();
        if (issuer == null) {
            this.log.debug("No relying party ID, no SAML2SPSession created");
            return null;
        }
        Pair<Assertion, AuthnStatement> result = this.getAssertionAndStatement(input);
        if (result == null) {
            this.log.info("Creating BasicSPSession in the absence of necessary information");
            Instant now = Instant.now();
            return new BasicSPSession(issuer, now, now.plus(this.sessionLifetime));
        }
        Instant now = Instant.now();
        Instant sessionBound = ((AuthnStatement)result.getSecond()).getSessionNotOnOrAfter();
        Instant expiration = sessionBound != null ? sessionBound : now.plus(this.sessionLifetime);
        return new SAML2SPSession(issuer, now, expiration, ((Assertion)result.getFirst()).getSubject().getNameID(), ((AuthnStatement)result.getSecond()).getSessionIndex());
    }

    @Nullable
    private Pair<Assertion, AuthnStatement> getAssertionAndStatement(@Nonnull ProfileRequestContext profileRequestContext) {
        Response response = this.responseLookupStrategy.apply(profileRequestContext);
        if (response == null) {
            this.log.debug("No Response message or Assertions found");
            return null;
        }
        for (Assertion assertion : response.getAssertions()) {
            if (assertion.getSubject() == null || assertion.getSubject().getNameID() == null) continue;
            for (AuthnStatement statement : assertion.getAuthnStatements()) {
                if (statement.getSessionIndex() == null) continue;
                return new Pair((Object)assertion, (Object)statement);
            }
        }
        this.log.debug("No suitable Assertion/AuthnStatement found");
        return null;
    }
}

