/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTransformingDecoder
extends AbstractIdentifiableInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseTransformingDecoder.class);
    @Nonnull
    @NonnullElements
    private List<Pair<Pattern, String>> transforms = Collections.emptyList();
    private boolean uppercase;
    private boolean lowercase;

    public void setUppercase(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.uppercase = flag;
    }

    public void setLowercase(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.lowercase = flag;
    }

    public void setTransforms(@Nonnull @NonnullElements Collection<Pair<String, String>> newTransforms) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(newTransforms, (String)"Transforms collection cannot be null");
        this.transforms = new ArrayList<Pair<Pattern, String>>();
        for (Pair<String, String> p : newTransforms) {
            Pattern pattern = Pattern.compile(StringSupport.trimOrNull((String)((String)p.getFirst())));
            this.transforms.add((Pair<Pattern, String>)new Pair((Object)pattern, (Object)((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)((String)p.getSecond())), (String)"Replacement expression cannot be null"))));
        }
    }

    @Nullable
    protected String decode(@Nonnull @NotEmpty String id) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        String s = id;
        if (this.lowercase) {
            this.log.debug("Converting input string '{}' to lowercase", (Object)s);
            s = s.toLowerCase();
        } else if (this.uppercase) {
            this.log.debug("Converting input string '{}' to uppercase", (Object)s);
            s = s.toUpperCase();
        }
        if (this.transforms.isEmpty()) {
            return s;
        }
        for (Pair<Pattern, String> p : this.transforms) {
            Matcher m = ((Pattern)p.getFirst()).matcher(s);
            this.log.debug("Applying replacement expression '{}' against input '{}'", (Object)((Pattern)p.getFirst()).pattern(), (Object)s);
            s = m.replaceAll((String)p.getSecond());
            this.log.debug("Result of replacement is '{}'", (Object)s);
        }
        return s;
    }
}

