/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.ResponseAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;

public class InResponseToAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> responseLookupStrategy;

    public InResponseToAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        SAMLObject response = this.responseLookupStrategy.apply(input);
        if (response != null) {
            if (response instanceof ResponseAbstractType) {
                return ((ResponseAbstractType)response).getInResponseTo();
            }
            if (response instanceof StatusResponseType) {
                return ((StatusResponseType)response).getInResponseTo();
            }
        }
        return null;
    }
}

