/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml2.core.ArtifactResponse;

public class AssertionIDAuditExtractor
implements Function<ProfileRequestContext, Collection<String>> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> responseLookupStrategy;

    public AssertionIDAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public Collection<String> apply(@Nullable ProfileRequestContext input) {
        SAMLObject message = this.responseLookupStrategy.apply(input);
        if (message != null) {
            if (message instanceof ArtifactResponse) {
                message = ((ArtifactResponse)message).getMessage();
            }
            if (message instanceof org.opensaml.saml.saml2.core.Response) {
                List assertions = ((org.opensaml.saml.saml2.core.Response)message).getAssertions();
                if (!assertions.isEmpty()) {
                    return assertions.stream().map(org.opensaml.saml.saml2.core.Assertion::getID).collect(Collectors.toList());
                }
            } else if (message instanceof Response) {
                List assertions = ((Response)message).getAssertions();
                if (!assertions.isEmpty()) {
                    return assertions.stream().map(Assertion::getID).collect(Collectors.toList());
                }
            } else {
                if (message instanceof org.opensaml.saml.saml2.core.Assertion) {
                    return Collections.singletonList(((org.opensaml.saml.saml2.core.Assertion)message).getID());
                }
                if (message instanceof Assertion) {
                    return Collections.singletonList(((Assertion)message).getID());
                }
            }
        }
        return Collections.emptyList();
    }
}

