/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.session.impl;

import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.session.SAML2SPSession;
import net.shibboleth.idp.session.context.LogoutPropagationContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddLogoutRequest
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AddLogoutRequest.class);
    private boolean overwriteExisting;
    private boolean includeSessionIndex = true;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy = new Function<ProfileRequestContext, IdentifierGenerationStrategy>(){

        @Override
        public IdentifierGenerationStrategy apply(ProfileRequestContext input) {
            return new SecureRandomIdentifierGenerationStrategy();
        }
    };
    @Nullable
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, LogoutPropagationContext> logoutPropContextLookupStrategy = new ChildContextLookup(LogoutPropagationContext.class);
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nullable
    private SAML2SPSession saml2Session;
    @Nullable
    private String issuerId;

    public void setOverwriteExisting(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.overwriteExisting = flag;
    }

    public void setIncludeSessionIndex(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.includeSessionIndex = flag;
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = strategy;
    }

    public void setLogoutPropagationContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutPropagationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.logoutPropContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutPropagationContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        LogoutPropagationContext logoutPropCtx;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        MessageContext outboundMessageCtx = profileRequestContext.getOutboundMessageContext();
        if (outboundMessageCtx == null) {
            this.log.debug("{} No outbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (!this.overwriteExisting && outboundMessageCtx.getMessage() != null) {
            this.log.debug("{} Outbound message context already contains a message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.debug("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (this.issuerLookupStrategy != null) {
            this.issuerId = this.issuerLookupStrategy.apply(profileRequestContext);
        }
        if ((logoutPropCtx = this.logoutPropContextLookupStrategy.apply(profileRequestContext)) == null) {
            this.log.debug("{} No logout propagation context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (logoutPropCtx.getSession() == null || !(logoutPropCtx.getSession() instanceof SAML2SPSession)) {
            this.log.debug("{} Logout propgation context did not contain a SAML2SPSession", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.saml2Session = (SAML2SPSession)logoutPropCtx.getSession();
        if (this.saml2Session.getId() == null) {
            this.log.debug("{} SAML2SPSession in logout propagation context did not contain a service ID", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        outboundMessageCtx.setMessage(null);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder requestBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(LogoutRequest.DEFAULT_ELEMENT_NAME);
        LogoutRequest object = (LogoutRequest)requestBuilder.buildObject();
        object.setID(this.idGenerator.generateIdentifier());
        object.setIssueInstant(Instant.now());
        object.setVersion(SAMLVersion.VERSION_20);
        try {
            NameID nameId = (NameID)XMLObjectSupport.cloneXMLObject((XMLObject)this.saml2Session.getNameID());
            object.setNameID(nameId);
        }
        catch (MarshallingException | UnmarshallingException e) {
            this.log.error("{} Error cloning NameID for use in LogoutRequest for {}", new Object[]{this.getLogPrefix(), this.saml2Session.getId(), e});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
            return;
        }
        if (this.issuerId != null) {
            this.log.debug("{} Setting Issuer to {}", (Object)this.getLogPrefix(), (Object)this.issuerId);
            SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(Issuer.DEFAULT_ELEMENT_NAME);
            Issuer issuer = (Issuer)issuerBuilder.buildObject();
            issuer.setValue(this.issuerId);
            object.setIssuer(issuer);
        } else {
            this.log.debug("{} No issuer value available, leaving Issuer unset", (Object)this.getLogPrefix());
        }
        if (this.includeSessionIndex) {
            SAMLObjectBuilder indexBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(SessionIndex.DEFAULT_ELEMENT_NAME);
            SessionIndex index = (SessionIndex)indexBuilder.buildObject();
            index.setValue(this.saml2Session.getSessionIndex());
            object.getSessionIndexes().add(index);
        }
        profileRequestContext.getOutboundMessageContext().setMessage((Object)object);
    }
}

