/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextDeclRefPrincipal;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRequestedAuthnContext
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProcessRequestedAuthnContext.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, AuthnRequest> authnRequestLookupStrategy = new MessageLookup(AuthnRequest.class).compose((Function)new InboundMessageContextLookup());
    @Nonnull
    @NonnullElements
    private Set<String> ignoredContexts = Collections.singleton("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
    @Nullable
    private AuthnRequest authnRequest;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setAuthnRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthnRequest> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authnRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthnRequest lookup strategy cannot be null");
    }

    public void setIgnoredContexts(@Nonnull @NonnullElements Collection<String> contexts) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Collection trimmed = StringSupport.normalizeStringCollection(contexts);
        this.ignoredContexts = trimmed.isEmpty() ? Collections.emptySet() : Set.copyOf(trimmed);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.authnRequest = this.authnRequestLookupStrategy.apply(profileRequestContext);
        if (this.authnRequest == null) {
            this.log.debug("{} AuthnRequest message was not returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        RequestedAuthnContext requestedCtx = this.authnRequest.getRequestedAuthnContext();
        if (requestedCtx == null) {
            this.log.debug("{} AuthnRequest did not contain a RequestedAuthnContext, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        ArrayList<Object> principals = new ArrayList<Object>();
        if (!requestedCtx.getAuthnContextClassRefs().isEmpty()) {
            for (AuthnContextClassRef ref : requestedCtx.getAuthnContextClassRefs()) {
                if (ref.getURI() == null) continue;
                if (!this.ignoredContexts.contains(ref.getURI())) {
                    principals.add(new AuthnContextClassRefPrincipal(ref.getURI()));
                    continue;
                }
                this.log.info("{} Ignoring AuthnContextClassRef: {}", (Object)this.getLogPrefix(), (Object)ref.getURI());
            }
        } else if (!requestedCtx.getAuthnContextDeclRefs().isEmpty()) {
            for (AuthnContextClassRef ref : requestedCtx.getAuthnContextDeclRefs()) {
                if (ref.getURI() == null) continue;
                if (!this.ignoredContexts.contains(ref.getURI())) {
                    principals.add(new AuthnContextDeclRefPrincipal(ref.getURI()));
                    continue;
                }
                this.log.info("{} Ignoring AuthnContextDeclRef: {}", (Object)this.getLogPrefix(), (Object)ref.getURI());
            }
        }
        if (principals.isEmpty()) {
            this.log.debug("{} RequestedAuthnContext did not contain any requested contexts, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        RelyingPartyContext rpContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpContext != null && rpContext.getProfileConfig() != null && rpContext.getProfileConfig() instanceof BrowserSSOProfileConfiguration && ((BrowserSSOProfileConfiguration)rpContext.getProfileConfig()).isFeatureDisallowed(profileRequestContext, 1)) {
            this.log.warn("{} Incoming RequestedAuthnContext disallowed by profile configuration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
            return;
        }
        RequestedPrincipalContext rpCtx = new RequestedPrincipalContext();
        if (requestedCtx.getComparison() != null) {
            rpCtx.setOperator(requestedCtx.getComparison().toString());
        } else {
            rpCtx.setOperator(AuthnContextComparisonTypeEnumeration.EXACT.toString());
        }
        rpCtx.setRequestedPrincipals(principals);
        authenticationContext.addSubcontext((BaseContext)rpCtx, true);
        this.log.debug("{} RequestedPrincipalContext created with operator {} and {} custom principal(s)", new Object[]{this.getLogPrefix(), rpCtx.getOperator(), principals.size()});
    }
}

