/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.AuthnRequest;

public class NameIDPolicySPNameQualifierAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, SAMLObject> messageLookupStrategy;

    public NameIDPolicySPNameQualifierAuditExtractor(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.messageLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        SAMLObject msg = this.messageLookupStrategy.apply(input);
        if (msg != null) {
            if (msg instanceof ArtifactResponse) {
                msg = ((ArtifactResponse)msg).getMessage();
            }
            if (msg instanceof AuthnRequest && ((AuthnRequest)msg).getNameIDPolicy() != null && ((AuthnRequest)msg).getNameIDPolicy().getSPNameQualifier() != null) {
                return ((AuthnRequest)msg).getNameIDPolicy().getSPNameQualifier();
            }
        }
        return null;
    }
}

