/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.navigate;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import org.opensaml.profile.context.ProfileRequestContext;

public class ProxyAwareDefaultAuthenticationMethodsLookupFunction
implements Function<ProfileRequestContext, Collection<AuthnContextClassRefPrincipal>> {
    @Nonnull
    @NonnullElements
    private Map<Principal, Collection<Principal>> principalMappings = Collections.emptyMap();

    public void setMappings(@Nullable @NonnullElements Map<Principal, Collection<Principal>> mappings) {
        if (mappings == null || mappings.isEmpty()) {
            this.principalMappings = Collections.emptyMap();
            return;
        }
        this.principalMappings = new HashMap<Principal, Collection<Principal>>(mappings.size());
        mappings.forEach((k, v) -> this.principalMappings.put((Principal)k, List.copyOf(v)));
    }

    @Override
    @Nullable
    public Collection<AuthnContextClassRefPrincipal> apply(@Nullable ProfileRequestContext input) {
        RequestedPrincipalContext rpc;
        if (input != null && input.getParent() instanceof AuthenticationContext && (rpc = (RequestedPrincipalContext)input.getParent().getSubcontext(RequestedPrincipalContext.class)) != null) {
            return rpc.getRequestedPrincipals().stream().map(p -> {
                if (this.principalMappings.containsKey(p)) {
                    return this.principalMappings.get(p);
                }
                return Collections.singletonList(p);
            }).flatMap(Collection::stream).filter(AuthnContextClassRefPrincipal.class::isInstance).map(AuthnContextClassRefPrincipal.class::cast).collect(Collectors.toUnmodifiableList());
        }
        return Collections.emptyList();
    }
}

