/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class ECPProfileConfiguration
extends BrowserSSOProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/saml2/sso/ecp";
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> localEventsLookupStrategy;

    public ECPProfileConfiguration() {
        this(PROFILE_ID);
        this.localEventsLookupStrategy = FunctionSupport.constant(null);
    }

    protected ECPProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getLocalEvents(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> events = this.localEventsLookupStrategy.apply(profileRequestContext);
        if (events != null) {
            return Set.copyOf(events);
        }
        return Collections.emptySet();
    }

    public void setLocalEvents(@Nullable @NonnullElements Collection<String> events) {
        this.localEventsLookupStrategy = events != null && !events.isEmpty() ? FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(events))) : FunctionSupport.constant(null);
    }

    public void setLocalEventsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.localEventsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

