/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import com.google.common.base.Predicates;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactAwareProfileConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactConsumerProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.config.AbstractSAML2ProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.logic.NoIntegrityMessageChannelPredicate;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractSAML2ArtifactAwareProfileConfiguration
extends AbstractSAML2ProfileConfiguration
implements SAMLArtifactAwareProfileConfiguration,
SAMLArtifactConsumerProfileConfiguration {
    @Nonnull
    private Function<ProfileRequestContext, SAMLArtifactConfiguration> artifactConfigurationLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<MessageContext> signArtifactRequestsPredicate = new NoIntegrityMessageChannelPredicate();
    @Nonnull
    private Predicate<MessageContext> clientTLSArtifactRequestsPredicate = new NoIntegrityMessageChannelPredicate().negate();

    protected AbstractSAML2ArtifactAwareProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Override
    @Nullable
    public SAMLArtifactConfiguration getArtifactConfiguration(@Nullable ProfileRequestContext profileRequestContext) {
        return this.artifactConfigurationLookupStrategy.apply(profileRequestContext);
    }

    public void setArtifactConfiguration(@Nullable SAMLArtifactConfiguration config) {
        this.artifactConfigurationLookupStrategy = FunctionSupport.constant((Object)config);
    }

    public void setArtifactConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLArtifactConfiguration> strategy) {
        this.artifactConfigurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    public boolean isSignArtifactRequests(@Nullable MessageContext messageContext) {
        return this.signArtifactRequestsPredicate.test(messageContext);
    }

    public void setSignArtifactRequests(boolean flag) {
        this.signArtifactRequestsPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setSignArtifactRequestsPredicate(@Nonnull Predicate<MessageContext> predicate) {
        this.signArtifactRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine artifact request signing may not be null");
    }

    @Override
    public boolean isClientTLSArtifactRequests(@Nullable MessageContext messageContext) {
        return this.clientTLSArtifactRequestsPredicate.test(messageContext);
    }

    public void setClientTLSArtifactRequests(boolean flag) {
        this.clientTLSArtifactRequestsPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setClientTLSArtifactRequestsPredicate(@Nonnull Predicate<MessageContext> predicate) {
        this.clientTLSArtifactRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine artifact client TLS use may not be null");
    }
}

