/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.config;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.config.AbstractSAMLProfileConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactAwareProfileConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactConfiguration;
import net.shibboleth.idp.saml.saml1.profile.config.SAML1ProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractSAML1ArtifactAwareProfileConfiguration
extends AbstractSAMLProfileConfiguration
implements SAML1ProfileConfiguration,
SAMLArtifactAwareProfileConfiguration {
    @Nonnull
    private Function<ProfileRequestContext, SAMLArtifactConfiguration> artifactConfigurationLookupStrategy = FunctionSupport.constant(null);

    protected AbstractSAML1ArtifactAwareProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Override
    @Nullable
    public SAMLArtifactConfiguration getArtifactConfiguration(@Nullable ProfileRequestContext profileRequestContext) {
        return this.artifactConfigurationLookupStrategy.apply(profileRequestContext);
    }

    public void setArtifactConfiguration(@Nullable SAMLArtifactConfiguration config) {
        this.artifactConfigurationLookupStrategy = FunctionSupport.constant((Object)config);
    }

    public void setArtifactConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLArtifactConfiguration> strategy) {
        this.artifactConfigurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

