/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.logic;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.profile.logic.EntityAttributesPredicate;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedEntityAttributesPredicate
extends EntityAttributesPredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MappedEntityAttributesPredicate.class);
    @Nonnull
    @NotEmpty
    private String scopeDelimiter = "@";

    public MappedEntityAttributesPredicate(@Nonnull @ParameterName(name="candidates") @NonnullElements Collection<EntityAttributesPredicate.Candidate> candidates) {
        super(candidates);
        Constraint.isTrue((boolean)Iterables.all(candidates, c -> c.getNameFormat() == null), (String)"Use of nameFormat property is impermissible with MappedEntityAttributesPredicate");
    }

    public MappedEntityAttributesPredicate(@Nonnull @ParameterName(name="candidates") @NonnullElements Collection<EntityAttributesPredicate.Candidate> candidates, @ParameterName(name="trim") boolean trim) {
        super(candidates, trim);
        Constraint.isTrue((boolean)Iterables.all(candidates, c -> c.getNameFormat() == null), (String)"Use of nameFormat property is impermissible with MappedEntityAttributesPredicate");
    }

    public MappedEntityAttributesPredicate(@Nonnull @ParameterName(name="candidates") @NonnullElements Collection<EntityAttributesPredicate.Candidate> candidates, @ParameterName(name="trim") boolean trim, @ParameterName(name="all") boolean all) {
        super(candidates, trim, all);
        Constraint.isTrue((boolean)Iterables.all(candidates, c -> c.getNameFormat() == null), (String)"Use of nameFormat property is impermissible with MappedEntityAttributesPredicate");
    }

    public void setScopeDelimiter(@Nonnull @NotEmpty String delimiter) {
        this.scopeDelimiter = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)delimiter), (String)"Scope delimiter cannot be null or empty");
    }

    public boolean test(@Nullable EntityDescriptor input) {
        if (this.getCandidates().isEmpty()) {
            return true;
        }
        if (input == null) {
            return false;
        }
        ArrayList<EntityAttributesPredicate.Candidate> candidates = new ArrayList<EntityAttributesPredicate.Candidate>(this.getCandidates());
        if (this.doTest((XMLObject)input, input.getEntityID(), candidates) && (!this.getMatchAll() || candidates.isEmpty())) {
            return true;
        }
        XMLObject parent = input.getParent();
        while (parent instanceof EntitiesDescriptor) {
            if (this.doTest(parent, ((EntitiesDescriptor)parent).getName(), candidates) && (!this.getMatchAll() || candidates.isEmpty())) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private boolean doTest(@Nullable XMLObject input, @Nullable String name, @Nonnull @NonnullElements Collection<EntityAttributesPredicate.Candidate> candidates) {
        List containerList = input.getObjectMetadata().get(AttributesMapContainer.class);
        if (null == containerList || containerList.isEmpty() || ((AttributesMapContainer)containerList.get(0)).get() == null || ((AttributesMapContainer)containerList.get(0)).get().isEmpty()) {
            this.log.trace("No mapped Entity Attributes for {}", (Object)name);
            return false;
        }
        Multimap entityAttributes = ((AttributesMapContainer)containerList.get(0)).get();
        this.log.trace("Checking for match against {} Entity Attributes for {}", (Object)entityAttributes.size(), (Object)name);
        return candidates.removeIf((Predicate<EntityAttributesPredicate.Candidate>)((Object)new EntityAttributesMatcher((Multimap<String, ? extends IdPAttribute>)entityAttributes)));
    }

    private class EntityAttributesMatcher
    implements net.shibboleth.utilities.java.support.logic.Predicate<EntityAttributesPredicate.Candidate> {
        @Nonnull
        private final Multimap<String, ? extends IdPAttribute> attributes;

        public EntityAttributesMatcher(Multimap<String, ? extends IdPAttribute> attrs) {
            this.attributes = (Multimap)Constraint.isNotNull(attrs, (String)"Extension attributes cannot be null");
        }

        public boolean test(@Nonnull EntityAttributesPredicate.Candidate input) {
            if (input.getNameFormat() != null) {
                return false;
            }
            List tagvals = input.getValues();
            List tagexps = input.getRegexps();
            boolean[] valflags = new boolean[tagvals.size()];
            boolean[] expflags = new boolean[tagexps.size()];
            for (IdPAttribute a : this.attributes.get((Object)input.getName())) {
                int tagindex;
                block1: for (tagindex = 0; tagindex < tagvals.size(); ++tagindex) {
                    String tagvalstr = (String)tagvals.get(tagindex);
                    for (IdPAttributeValue cval : a.getValues()) {
                        String cvalstr = this.attributeValueToString(cval);
                        if (tagvalstr == null || cvalstr == null) continue;
                        if (tagvalstr.equals(cvalstr)) {
                            MappedEntityAttributesPredicate.this.log.trace("Matched mapped Entity Attribute ({}) value {}", (Object)a.getId(), (Object)tagvalstr);
                            valflags[tagindex] = true;
                            continue block1;
                        }
                        if (!MappedEntityAttributesPredicate.this.getTrimTags() || !tagvalstr.equals(cvalstr.trim())) continue;
                        MappedEntityAttributesPredicate.this.log.trace("Matched mapped Entity Attribute ({}) value {}", (Object)a.getId(), (Object)tagvalstr);
                        valflags[tagindex] = true;
                        continue block1;
                    }
                }
                block3: for (tagindex = 0; tagindex < tagexps.size(); ++tagindex) {
                    for (IdPAttributeValue cval : a.getValues()) {
                        String cvalstr = this.attributeValueToString(cval);
                        if (tagexps.get(tagindex) == null || cvalstr == null || !((Pattern)tagexps.get(tagindex)).matcher(cvalstr).matches()) continue;
                        MappedEntityAttributesPredicate.this.log.trace("Matched mapped Entity Attribute ({}) value {}", (Object)a.getId(), (Object)cvalstr);
                        expflags[tagindex] = true;
                        continue block3;
                    }
                }
            }
            for (Object flag : (Object)valflags) {
                if (flag != false) continue;
                return false;
            }
            for (Object flag : (Object)expflags) {
                if (flag != false) continue;
                return false;
            }
            return true;
        }

        @Nullable
        private String attributeValueToString(@Nonnull IdPAttributeValue value) {
            if (value instanceof ScopedStringAttributeValue) {
                return ((ScopedStringAttributeValue)value).getValue() + MappedEntityAttributesPredicate.this.scopeDelimiter + ((ScopedStringAttributeValue)value).getScope();
            }
            if (value instanceof StringAttributeValue) {
                return ((StringAttributeValue)value).getValue();
            }
            if (value instanceof EmptyAttributeValue) {
                EmptyAttributeValue.EmptyType empty = ((EmptyAttributeValue)value).getValue();
                return EmptyAttributeValue.EmptyType.ZERO_LENGTH_VALUE.equals((Object)empty) ? "" : null;
            }
            return null;
        }
    }
}

