/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config.navigate;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import net.shibboleth.idp.saml.profile.config.SAMLProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import org.opensaml.profile.context.ProfileRequestContext;

public class AudienceRestrictionsLookupFunction
extends AbstractRelyingPartyLookupFunction<Collection<String>> {
    @Nullable
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Collection<String> apply(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            Set<String> additional;
            String id = rpc.getRelyingPartyId();
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc != null && pc instanceof SAMLProfileConfiguration && !(additional = ((SAMLProfileConfiguration)pc).getAdditionalAudiencesForAssertion(input)).isEmpty()) {
                ImmutableList.Builder builder = ImmutableList.builder();
                if (id != null) {
                    builder.add((Object)rpc.getRelyingPartyId());
                }
                builder.addAll(additional);
                return builder.build();
            }
            if (id != null) {
                return List.of(rpc.getRelyingPartyId());
            }
        }
        return Collections.emptyList();
    }
}

