/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config.logic;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Predicate;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLPresenterEntityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllowedSAMLPresentersPredicate
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AllowedSAMLPresentersPredicate.class);
    @Nonnull
    private Set<String> allowedPresenters = Collections.emptySet();

    public void setAllowedPresenters(@Nullable Collection<String> presenters) {
        this.allowedPresenters = presenters == null ? Collections.emptySet() : new HashSet<String>(StringSupport.normalizeStringCollection(presenters));
    }

    public boolean test(@Nullable ProfileRequestContext input) {
        if (input == null || input.getInboundMessageContext() == null) {
            this.log.debug("ProfileRequestContext or inbound MessageContext were null");
            return false;
        }
        SAMLPresenterEntityContext presenterContext = (SAMLPresenterEntityContext)input.getInboundMessageContext().getSubcontext(SAMLPresenterEntityContext.class);
        if (presenterContext == null) {
            this.log.debug("No inbound SAMLPresenterEntityContext");
            return false;
        }
        boolean result = this.allowedPresenters.contains(presenterContext.getEntityId());
        this.log.debug("SAML presenter '{}' was {} in set of allowed presenters", (Object)presenterContext.getEntityId(), (Object)(result ? "found" : "NOT found"));
        return result;
    }
}

