/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import java.time.Duration;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.config.StringToDurationConverter;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.saml.profile.config.AbstractMetadataDrivenConfigurationLookupStrategy;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class DurationConfigurationLookupStrategy
extends AbstractMetadataDrivenConfigurationLookupStrategy<Duration> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DurationConfigurationLookupStrategy.class);
    @Nonnull
    private final Converter<String, Duration> durationConverter = new StringToDurationConverter();

    @Override
    @Nullable
    protected Duration doTranslate(@Nonnull IdPAttribute tag) {
        List values = tag.getValues();
        if (values.size() != 1) {
            this.log.error("Tag '{}' contained multiple values, returning none", (Object)tag.getId());
            return null;
        }
        this.log.debug("Converting tag '{}' to Duration property", (Object)tag.getId());
        IdPAttributeValue value = (IdPAttributeValue)values.get(0);
        if (value instanceof StringAttributeValue) {
            try {
                return (Duration)this.durationConverter.convert((Object)((StringAttributeValue)value).getValue());
            }
            catch (IllegalArgumentException e) {
                this.log.error("Error converting duration", (Throwable)e);
                return null;
            }
        }
        this.log.error("Tag '{}' contained non-string value, returning null");
        return null;
    }

    @Override
    @Nullable
    protected Duration doTranslate(@Nonnull Attribute tag) {
        List values = tag.getAttributeValues();
        if (values.size() != 1) {
            this.log.error("Tag '{}' contained multiple values, returning none", (Object)tag.getName());
            return null;
        }
        this.log.debug("Converting tag '{}' to Duration property", (Object)tag.getName());
        return this.xmlObjectToDuration((XMLObject)values.get(0));
    }

    @Nullable
    private Duration xmlObjectToDuration(@Nonnull XMLObject object) {
        XSAny wc;
        if (object instanceof XSString) {
            String value = ((XSString)object).getValue();
            if (value != null) {
                try {
                    return (Duration)this.durationConverter.convert((Object)value);
                }
                catch (IllegalArgumentException e) {
                    this.log.error("Error converting duration", (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        if (object instanceof XSInteger) {
            Integer value = ((XSInteger)object).getValue();
            return value != null ? Duration.ofMillis(value.longValue()) : null;
        }
        if (object instanceof XSAny && (wc = (XSAny)object).getUnknownAttributes().isEmpty() && wc.getUnknownXMLObjects().isEmpty()) {
            String value = wc.getTextContent();
            if (value != null) {
                try {
                    return (Duration)this.durationConverter.convert((Object)value);
                }
                catch (IllegalArgumentException e) {
                    this.log.error("Error converting duration", (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        this.log.error("Unsupported conversion to Duration from XMLObject type ({})", (Object)object.getClass().getName());
        return null;
    }
}

