/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.saml.profile.context.navigate.messaging.SAMLMetadataContextLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.LockableClassToInstanceMultiMap;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.ProfileIdLookup;
import org.opensaml.saml.common.messaging.context.navigate.EntityDescriptorLookupFunction;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.soap.client.security.SOAPClientSecurityProfileIdLookupFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetadataDrivenConfigurationLookupStrategy<T>
extends AbstractInitializableComponent
implements Function<BaseContext, T> {
    @Nonnull
    private static final Function<ProfileRequestContext, EntityDescriptor> DEFAULT_PRC_METADATA_LOOKUP = new EntityDescriptorLookupFunction().compose((Function)((Object)new net.shibboleth.idp.saml.profile.context.navigate.SAMLMetadataContextLookupFunction()));
    @Nonnull
    private static final Function<ProfileRequestContext, String> DEFAULT_PRC_PROFILE_ID_LOOKUP = new ProfileIdLookup();
    @Nonnull
    private static final Function<MessageContext, EntityDescriptor> DEFAULT_MC_METADATA_LOOKUP = new EntityDescriptorLookupFunction().compose((Function)((Object)new SAMLMetadataContextLookupFunction()));
    @Nonnull
    private static final Function<MessageContext, String> DEFAULT_MC_PROFILE_ID_LOOKUP = new SOAPClientSecurityProfileIdLookupFunction();
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractMetadataDrivenConfigurationLookupStrategy.class);
    private boolean strictNameFormat;
    private boolean enableCaching = true;
    private boolean ignoreUnmappedEntityAttributes;
    @NonnullAfterInit
    @NotEmpty
    private String propertyName;
    @NonnullAfterInit
    @NonnullElements
    private Collection<String> propertyAliases;
    @Nullable
    private Function<BaseContext, T> defaultValueStrategy = FunctionSupport.constant(null);
    @Nullable
    private Function<BaseContext, EntityDescriptor> metadataLookupStrategy;
    @Nullable
    @NotEmpty
    private Function<BaseContext, String> profileIdLookupStrategy;

    public void setStrictNameFormat(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.strictNameFormat = flag;
    }

    public void setEnableCaching(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.enableCaching = flag;
    }

    public void setIgnoreUnmappedEntityAttributes(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.ignoreUnmappedEntityAttributes = flag;
    }

    public void setPropertyName(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.propertyName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Property name cannot be null or empty");
    }

    public void setProfileAliases(@Nonnull @NonnullElements Collection<String> aliases) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(aliases, (String)"Alias collection cannot be null");
        this.propertyAliases = List.copyOf(StringSupport.normalizeStringCollection(aliases));
    }

    public void setDefaultValue(@Nullable T value) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.defaultValueStrategy = FunctionSupport.constant(value);
    }

    public void setDefaultValueStrategy(@Nonnull Function<BaseContext, T> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.defaultValueStrategy = (Function)Constraint.isNotNull(strategy, (String)"Default value strategy cannot be null");
    }

    public void setMetadataLookupStrategy(@Nonnull Function<BaseContext, EntityDescriptor> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Metadata lookup strategy cannot be null");
    }

    public void setProfileIdLookupStrategy(@Nonnull Function<BaseContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.profileIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Profile ID lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.propertyName == null) {
            throw new ComponentInitializationException("Property name cannot be null or empty");
        }
        if (this.propertyAliases == null) {
            this.propertyAliases = Collections.emptyList();
        }
        this.propertyAliases = this.propertyAliases.stream().map(s -> s + (String)(s.endsWith("/") ? this.propertyName : "/" + this.propertyName)).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @Nullable
    public T apply(@Nullable BaseContext input) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        CachedConfigurationContext cacheContext = null;
        if (this.enableCaching && input != null && (cacheContext = (CachedConfigurationContext)input.getSubcontext(CachedConfigurationContext.class, true)).getPropertyMap().containsKey(this.propertyName)) {
            this.log.debug("Returning cached property '{}'", (Object)this.propertyName);
            return (T)cacheContext.getPropertyMap().get(this.propertyName);
        }
        Object entity = this.metadataLookupStrategy != null ? this.metadataLookupStrategy.apply(input) : (input instanceof ProfileRequestContext ? DEFAULT_PRC_METADATA_LOOKUP.apply((ProfileRequestContext)input) : (input instanceof MessageContext ? DEFAULT_MC_METADATA_LOOKUP.apply((MessageContext)input) : null));
        if (entity == null) {
            this.log.debug("No metadata available for relying party, applying default strategy for '{}'", (Object)this.propertyName);
            return this.defaultValueStrategy.apply(input);
        }
        String profileId = this.profileIdLookupStrategy != null ? this.profileIdLookupStrategy.apply(input) : (input instanceof ProfileRequestContext ? DEFAULT_PRC_PROFILE_ID_LOOKUP.apply((ProfileRequestContext)input) : (input instanceof MessageContext ? DEFAULT_MC_PROFILE_ID_LOOKUP.apply((MessageContext)input) : ""));
        IdPAttribute idpAttribute = this.findMatchingMappedTag((EntityDescriptor)entity, profileId + "/" + this.propertyName);
        if (idpAttribute != null) {
            this.log.debug("Found matching tag '{}' for property '{}'", (Object)idpAttribute.getId(), (Object)this.propertyName);
            T result = this.translate(idpAttribute);
            if (this.enableCaching) {
                cacheContext.getPropertyMap().put(this.propertyName, result);
            }
            return result;
        }
        for (String alias : this.propertyAliases) {
            idpAttribute = this.findMatchingMappedTag((EntityDescriptor)entity, alias);
            if (idpAttribute == null) continue;
            this.log.debug("Found matching tag '{}' for property '{}'", (Object)idpAttribute.getId(), (Object)this.propertyName);
            T result = this.translate(idpAttribute);
            if (this.enableCaching) {
                cacheContext.getPropertyMap().put(this.propertyName, result);
            }
            return result;
        }
        if (this.ignoreUnmappedEntityAttributes) {
            this.log.debug("No applicable mapped tag, applying default strategy for '{}'", (Object)this.propertyName);
            T ret = this.defaultValueStrategy.apply(input);
            if (this.enableCaching) {
                cacheContext.getPropertyMap().put(this.propertyName, ret);
            }
            return ret;
        }
        Attribute attribute = this.findMatchingTag((EntityDescriptor)entity, profileId + "/" + this.propertyName);
        if (attribute != null) {
            this.log.debug("Found matching tag '{}' for property '{}'", (Object)attribute.getName(), (Object)this.propertyName);
            Iterator<String> result = this.translate(attribute);
            if (this.enableCaching) {
                cacheContext.getPropertyMap().put(this.propertyName, result);
            }
            return (T)result;
        }
        for (String alias : this.propertyAliases) {
            attribute = this.findMatchingTag((EntityDescriptor)entity, alias);
            if (attribute == null) continue;
            this.log.debug("Found matching tag '{}' for property '{}'", (Object)attribute.getName(), (Object)this.propertyName);
            T result = this.translate(attribute);
            if (this.enableCaching) {
                cacheContext.getPropertyMap().put(this.propertyName, result);
            }
            return result;
        }
        this.log.debug("No applicable tag, applying default strategy for '{}'", (Object)this.propertyName);
        T ret = this.defaultValueStrategy.apply(input);
        if (this.enableCaching) {
            cacheContext.getPropertyMap().put(this.propertyName, ret);
        }
        return ret;
    }

    @Nullable
    private T translate(@Nonnull Attribute tag) {
        List values = tag.getAttributeValues();
        if (values == null || values.isEmpty()) {
            this.log.debug("Tag '{}' contained no values, no setting returned for '{}'", (Object)tag.getName(), (Object)this.propertyName);
            return null;
        }
        return this.doTranslate(tag);
    }

    @Nullable
    private T translate(@Nonnull IdPAttribute tag) {
        List values = tag.getValues();
        if (values == null || values.isEmpty()) {
            this.log.debug("Tag '{}' contained no values, no setting returned for '{}'", (Object)tag.getId(), (Object)this.propertyName);
            return null;
        }
        return this.doTranslate(tag);
    }

    @Nullable
    protected abstract T doTranslate(@Nonnull Attribute var1);

    @Nullable
    protected abstract T doTranslate(@Nonnull IdPAttribute var1);

    @Nullable
    private IdPAttribute findMatchingMappedTag(@Nonnull EntityDescriptor entity, @Nonnull @NotEmpty String name) {
        IdPAttribute tag = this.findMatchingMappedTag(entity.getObjectMetadata(), name);
        if (tag != null) {
            return tag;
        }
        XMLObject parent = entity.getParent();
        while (parent instanceof EntitiesDescriptor) {
            tag = this.findMatchingMappedTag(parent.getObjectMetadata(), name);
            if (tag != null) {
                return tag;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Nullable
    private Attribute findMatchingTag(@Nonnull EntityDescriptor entity, @Nonnull @NotEmpty String name) {
        Attribute tag;
        List children;
        Extensions exts = entity.getExtensions();
        if (exts != null && !(children = exts.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME)).isEmpty() && children.get(0) instanceof EntityAttributes && (tag = this.findMatchingTag((EntityAttributes)children.get(0), name)) != null) {
            return tag;
        }
        for (EntitiesDescriptor group = (EntitiesDescriptor)entity.getParent(); group != null; group = (EntitiesDescriptor)group.getParent()) {
            Attribute tag2;
            List children2;
            exts = group.getExtensions();
            if (exts == null || (children2 = exts.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME)).isEmpty() || !(children2.get(0) instanceof EntityAttributes) || (tag2 = this.findMatchingTag((EntityAttributes)children2.get(0), name)) == null) continue;
            return tag2;
        }
        return null;
    }

    @Nullable
    private IdPAttribute findMatchingMappedTag(@Nonnull LockableClassToInstanceMultiMap<?> input, @Nonnull @NotEmpty String name) {
        List containerList = input.get(AttributesMapContainer.class);
        if (null == containerList || containerList.isEmpty() || ((AttributesMapContainer)containerList.get(0)).get() == null || ((AttributesMapContainer)containerList.get(0)).get().isEmpty()) {
            return null;
        }
        Collection matches = ((AttributesMapContainer)containerList.get(0)).get().get((Object)name);
        return matches.isEmpty() ? null : (IdPAttribute)matches.iterator().next();
    }

    @Nullable
    private Attribute findMatchingTag(@Nonnull EntityAttributes entityAttributes, @Nonnull @NotEmpty String name) {
        for (Attribute tag : entityAttributes.getAttributes()) {
            if (!Objects.equals(tag.getName(), name) || this.strictNameFormat && !Objects.equals(tag.getNameFormat(), "urn:oasis:names:tc:SAML:2.0:attrname-format:uri")) continue;
            return tag;
        }
        return null;
    }

    public static final class CachedConfigurationContext
    extends BaseContext {
        @Nonnull
        private Map<String, Object> propertyMap = new HashMap<String, Object>();

        @Nonnull
        @Live
        Map<String, Object> getPropertyMap() {
            return this.propertyMap;
        }
    }
}

