/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.config.AbstractSAMLProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.config.SAML2ProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractSAML2ProfileConfiguration
extends AbstractSAMLProfileConfiguration
implements SAML2ProfileConfiguration {
    @Nonnull
    private Predicate<ProfileRequestContext> encryptionOptionalPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptAssertionsPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptNameIDsPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptAttributesPredicate = Predicates.alwaysFalse();
    @Nullable
    private Function<ProfileRequestContext, Long> proxyCountLookupStrategy;
    private long proxyCount = 0L;
    @Nullable
    private Function<ProfileRequestContext, Collection<String>> proxyAudiencesLookupStrategy;
    @Nonnull
    @NonnullElements
    private Collection<String> proxyAudiences = Collections.emptyList();

    public AbstractSAML2ProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Override
    public long getProxyCount() {
        return Constraint.isGreaterThanOrEqual((long)0L, (long)((Long)this.getIndirectProperty(this.proxyCountLookupStrategy, this.proxyCount)), (String)"Proxy count must be greater than or equal to 0");
    }

    public void setProxyCount(@NonNegative long count) {
        this.proxyCount = Constraint.isGreaterThanOrEqual((long)0L, (long)count, (String)"Proxy count must be greater than or equal to 0");
    }

    public void setProxyCountLookupStrategy(@Nullable Function<ProfileRequestContext, Long> strategy) {
        this.proxyCountLookupStrategy = strategy;
    }

    @Override
    public Collection<String> getProxyAudiences() {
        return ImmutableList.copyOf((Collection)((Collection)this.getIndirectProperty(this.proxyAudiencesLookupStrategy, this.proxyAudiences)));
    }

    public void setProxyAudiences(@Nullable @NonnullElements Collection<String> audiences) {
        this.proxyAudiences = audiences == null ? Collections.emptyList() : StringSupport.normalizeStringCollection(audiences);
    }

    public void setProxyAudiencesLookupStrategy(@Nullable Function<ProfileRequestContext, Collection<String>> strategy) {
        this.proxyAudiencesLookupStrategy = strategy;
    }

    @Override
    public boolean isEncryptionOptional() {
        return this.encryptionOptionalPredicate.apply((Object)this.getProfileRequestContext());
    }

    public void setEncryptionOptional(boolean flag) {
        this.encryptionOptionalPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getEncryptionOptionalPredicate() {
        return this.encryptionOptionalPredicate;
    }

    public void setEncryptionOptionalPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.encryptionOptionalPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Encryption optional predicate cannot be null");
    }

    @Override
    @Nonnull
    public Predicate<ProfileRequestContext> getEncryptAssertions() {
        return this.encryptAssertionsPredicate;
    }

    public void setEncryptAssertions(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.encryptAssertionsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate to determine if assertions should be enecrypted cannot be null");
    }

    @Override
    @Nonnull
    public Predicate<ProfileRequestContext> getEncryptNameIDs() {
        return this.encryptNameIDsPredicate;
    }

    public void setEncryptNameIDs(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.encryptNameIDsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate to determine if name identifiers should be encrypted cannot be null");
    }

    @Override
    @Nonnull
    public Predicate<ProfileRequestContext> getEncryptAttributes() {
        return this.encryptAttributesPredicate;
    }

    public void setEncryptAttributes(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.encryptAttributesPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate to determine if attributes should be encrypted cannot be null");
    }
}

