/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.AbstractProfileConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAMLProfileConfiguration
extends AbstractProfileConfiguration
implements SAMLProfileConfiguration {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSAMLProfileConfiguration.class);
    @Nonnull
    private Predicate<ProfileRequestContext> signRequestsPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> signResponsesPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> signAssertionsPredicate = Predicates.alwaysFalse();
    @Nullable
    private Predicate<ProfileRequestContext> includeNotBeforePredicate = Predicates.alwaysTrue();
    @Nullable
    private Function<ProfileRequestContext, Long> assertionLifetimeLookupStrategy;
    @Duration
    @Positive
    private long assertionLifetime = 300000L;
    @Nullable
    private Function<ProfileRequestContext, Collection<String>> assertionAudiencesLookupStrategy;
    @Nonnull
    @NonnullElements
    private Set<String> assertionAudiences = Collections.emptySet();

    public AbstractSAMLProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getInboundInterceptorFlows() {
        List flows = super.getInboundInterceptorFlows();
        if (flows.isEmpty()) {
            this.log.warn("Inbound interceptor collection is empty, this disables default inbound message security checks");
        }
        return flows;
    }

    @Override
    @Nonnull
    public Predicate<ProfileRequestContext> getSignAssertions() {
        return this.signAssertionsPredicate;
    }

    public void setSignAssertions(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signAssertionsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate to determine if assertions should be signed cannot be null");
    }

    @Override
    @Nonnull
    public Predicate<ProfileRequestContext> getSignRequests() {
        return this.signRequestsPredicate;
    }

    public void setSignRequests(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate to determine if requests should be signed cannot be null");
    }

    @Override
    @Nonnull
    public Predicate<ProfileRequestContext> getSignResponses() {
        return this.signResponsesPredicate;
    }

    public void setSignResponses(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signResponsesPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate to determine if responses should be signed cannot be null");
    }

    @Override
    @Duration
    @Positive
    public long getAssertionLifetime() {
        return Constraint.isGreaterThan((long)0L, (long)((Long)this.getIndirectProperty(this.assertionLifetimeLookupStrategy, this.assertionLifetime)), (String)"Assertion lifetime must be greater than 0");
    }

    @Duration
    public void setAssertionLifetime(@Duration @Positive long lifetime) {
        this.assertionLifetime = Constraint.isGreaterThan((long)0L, (long)lifetime, (String)"Assertion lifetime must be greater than 0");
    }

    public void setAssertionLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Long> strategy) {
        this.assertionLifetimeLookupStrategy = strategy;
    }

    @Override
    public boolean includeConditionsNotBefore() {
        return this.includeNotBeforePredicate.apply((Object)this.getProfileRequestContext());
    }

    public void setIncludeConditionsNotBefore(boolean include) {
        this.includeNotBeforePredicate = include ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getIncludeConditionsNotBeforePredicate() {
        return this.includeNotBeforePredicate;
    }

    public void setIncludeConditionsNotBeforePredicate(@Nullable Predicate<ProfileRequestContext> condition) {
        this.includeNotBeforePredicate = (Predicate)Constraint.isNotNull(condition, (String)"NotBefore predicate cannot be null");
    }

    @Override
    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getAdditionalAudiencesForAssertion() {
        return ImmutableSet.copyOf((Collection)((Collection)this.getIndirectProperty(this.assertionAudiencesLookupStrategy, this.assertionAudiences)));
    }

    @Deprecated
    public void setAdditionalAudienceForAssertion(@Nonnull @NonnullElements Collection<String> audiences) {
        LoggerFactory.getLogger(AbstractSAMLProfileConfiguration.class).warn("Use of deprecated property name 'additionalAudienceForAssertion', please correct to 'additionalAudiencesForAssertion'");
        this.setAdditionalAudiencesForAssertion(audiences);
    }

    public void setAdditionalAudiencesForAssertion(@Nullable @NonnullElements Collection<String> audiences) {
        if (audiences == null || audiences.isEmpty()) {
            this.assertionAudiences = Collections.emptySet();
        } else {
            this.assertionAudiences = new HashSet<String>();
            for (String audience : audiences) {
                String trimmedAudience = StringSupport.trimOrNull((String)audience);
                if (trimmedAudience == null) continue;
                this.assertionAudiences.add(trimmedAudience);
            }
        }
    }

    public void setAssertionAudiencesLookupStrategy(@Nullable Function<ProfileRequestContext, Collection<String>> strategy) {
        this.assertionAudiencesLookupStrategy = strategy;
    }
}

