/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.relyingparty;

import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.IdentifiedComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelyingPartyConfiguration
extends AbstractIdentifiableInitializableComponent
implements IdentifiedComponent,
Predicate<ProfileRequestContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RelyingPartyConfiguration.class);
    @Nonnull
    private Function<ProfileRequestContext, String> responderIdLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> detailedErrorsPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Map<String, ProfileConfiguration>> profileConfigurationsLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = Predicates.alwaysTrue();

    public RelyingPartyConfiguration() {
        this.detailedErrorsPredicate = Predicates.alwaysFalse();
        this.profileConfigurationsLookupStrategy = FunctionSupport.constant(null);
    }

    @Nonnull
    @NotEmpty
    public String getResponderId(@Nullable ProfileRequestContext profileRequestContext) {
        return Constraint.isNotEmpty((String)this.responderIdLookupStrategy.apply(profileRequestContext), (String)"ResponderId cannot be null");
    }

    public void setResponderId(@Nonnull @NotEmpty String responder) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        String id = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)responder), (String)"ResponseId cannot be null or empty");
        this.responderIdLookupStrategy = FunctionSupport.constant((Object)id);
    }

    public void setResponderIdLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responderIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isDetailedErrors(@Nullable ProfileRequestContext profileRequestContext) {
        return this.detailedErrorsPredicate.test(profileRequestContext);
    }

    public void setDetailedErrors(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.detailedErrorsPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setDetailedErrorsPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.detailedErrorsPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Map<String, ProfileConfiguration> getProfileConfigurations(@Nullable ProfileRequestContext profileRequestContext) {
        Map<String, ProfileConfiguration> map = this.profileConfigurationsLookupStrategy.apply(profileRequestContext);
        if (map != null) {
            return Map.copyOf(map);
        }
        return Collections.emptyMap();
    }

    @Nullable
    public ProfileConfiguration getProfileConfiguration(@Nullable ProfileRequestContext profileRequestContext, @Nullable String profileId) {
        String trimmedId = StringSupport.trimOrNull((String)profileId);
        if (trimmedId == null) {
            return null;
        }
        return this.getProfileConfigurations(profileRequestContext).get(trimmedId);
    }

    public void setProfileConfigurations(@Nullable @NonnullElements Collection<ProfileConfiguration> configs) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (configs == null) {
            this.profileConfigurationsLookupStrategy = FunctionSupport.constant(null);
        } else {
            HashMap<String, ProfileConfiguration> map = new HashMap<String, ProfileConfiguration>();
            for (ProfileConfiguration config : List.copyOf(configs)) {
                String trimmedId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)config.getId()), (String)("ID of profile configuration class " + config.getClass().getName() + " cannot be null"));
                map.put(trimmedId, config);
            }
            this.profileConfigurationsLookupStrategy = FunctionSupport.constant(Map.copyOf(map));
        }
    }

    public void setProfileConfigurationsLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, ProfileConfiguration>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.profileConfigurationsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Relying partying configuration activation condition cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.responderIdLookupStrategy == null) {
            throw new ComponentInitializationException("Responder ID lookup strategy cannot be null");
        }
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return this.activationCondition.test(input);
    }
}

