/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor;

import com.google.common.base.Strings;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.profile.context.ExternalInterceptorContext;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.ExternalInterceptorException;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;
import org.springframework.webflow.executor.FlowExecutorImpl;

public abstract class ExternalInterceptor {
    @Nonnull
    @NotEmpty
    public static final String SWF_KEY = "net.shibboleth.idp.flowExecutor";
    @Nonnull
    @NotEmpty
    public static final String CONVERSATION_KEY = "conversation";
    @Nonnull
    @NotEmpty
    public static final String EVENT_KEY = "event";

    @Nonnull
    @NotEmpty
    public static String getExternalRedirect(@Nonnull @NotEmpty String baseLocation, @Nonnull @NotEmpty String conversationValue) {
        Constraint.isNotEmpty((String)baseLocation, (String)"Base location cannot be null or empty");
        StringBuilder url = new StringBuilder(baseLocation);
        url.append(baseLocation.indexOf(63) == -1 ? (char)'?' : '&');
        url.append(CONVERSATION_KEY).append('=').append(UrlEscapers.urlFormParameterEscaper().escape(conversationValue));
        return url.toString();
    }

    @Nonnull
    @NotEmpty
    public static String startExternalInterceptor(@Nonnull HttpServletRequest request) throws ExternalInterceptorException {
        String key = request.getParameter(CONVERSATION_KEY);
        if (Strings.isNullOrEmpty((String)key)) {
            throw new ExternalInterceptorException("No conversation key found in request");
        }
        ProfileRequestContext profileRequestContext = ExternalInterceptor.getProfileRequestContext(key, request);
        ExternalInterceptorContext extContext = ExternalInterceptor.getExternalInterceptorContext(profileRequestContext);
        extContext.getExternalInterceptor().doStart(request, profileRequestContext, extContext);
        return key;
    }

    public static void finishExternalInterceptor(@Nonnull @NotEmpty String key, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws ExternalInterceptorException, IOException {
        ProfileRequestContext profileRequestContext = ExternalInterceptor.getProfileRequestContext(key, request);
        ExternalInterceptorContext extContext = ExternalInterceptor.getExternalInterceptorContext(profileRequestContext);
        extContext.getExternalInterceptor().doFinish(request, response, profileRequestContext, extContext);
    }

    @Nonnull
    public static ProfileRequestContext getProfileRequestContext(@Nonnull @NotEmpty String key, @Nonnull HttpServletRequest request) throws ExternalInterceptorException {
        Object obj = request.getServletContext().getAttribute(SWF_KEY);
        if (!(obj instanceof FlowExecutorImpl)) {
            throw new ExternalInterceptorException("No FlowExecutor available in servlet context");
        }
        try {
            FlowExecutionRepository repo = ((FlowExecutorImpl)obj).getExecutionRepository();
            ExternalContextHolder.setExternalContext((ExternalContext)new ServletExternalContext(request.getServletContext(), request, null));
            FlowExecution execution = repo.getFlowExecution(repo.parseFlowExecutionKey(key));
            Object prc = execution.getConversationScope().get("opensamlProfileRequestContext");
            if (!(prc instanceof ProfileRequestContext)) {
                throw new ExternalInterceptorException("ProfileRequestContext not available in webflow conversation scope");
            }
            ProfileRequestContext profileRequestContext = (ProfileRequestContext)prc;
            return profileRequestContext;
        }
        catch (FlowExecutionRepositoryException e) {
            throw new ExternalInterceptorException("Error retrieving flow conversation", (Exception)((Object)e));
        }
        finally {
            ExternalContextHolder.setExternalContext(null);
        }
    }

    @Nonnull
    private static ExternalInterceptorContext getExternalInterceptorContext(@Nonnull ProfileRequestContext profileRequestContext) throws ExternalInterceptorException {
        ProfileInterceptorContext piContext = (ProfileInterceptorContext)profileRequestContext.getSubcontext(ProfileInterceptorContext.class);
        if (piContext == null) {
            throw new ExternalInterceptorException("No ProfileInterceptorContext found");
        }
        ExternalInterceptorContext extContext = (ExternalInterceptorContext)piContext.getSubcontext(ExternalInterceptorContext.class);
        if (extContext == null) {
            throw new ExternalInterceptorException("No ExternalInterceptorContext found");
        }
        return extContext;
    }

    protected void doStart(@Nonnull HttpServletRequest request, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull ExternalInterceptorContext externalInterceptorContext) throws ExternalInterceptorException {
        request.setAttribute("opensamlProfileRequestContext", (Object)profileRequestContext);
    }

    protected abstract void doFinish(@Nonnull HttpServletRequest var1, @Nonnull HttpServletResponse var2, @Nonnull ProfileRequestContext var3, @Nonnull ExternalInterceptorContext var4) throws ExternalInterceptorException, IOException;
}

