/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config.navigate.messaging;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.messaging.AbstractRelyingPartyLookupFunction;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureValidationConfiguration;

public class SignatureValidationConfigurationLookupFunction
extends AbstractRelyingPartyLookupFunction<List<SignatureValidationConfiguration>> {
    @Nullable
    private RelyingPartyConfigurationResolver rpResolver;

    public void setRelyingPartyConfigurationResolver(@Nullable RelyingPartyConfigurationResolver resolver) {
        this.rpResolver = resolver;
    }

    @Nullable
    public List<SignatureValidationConfiguration> apply(@Nullable MessageContext input) {
        ArrayList<SignatureValidationConfiguration> configs = new ArrayList<SignatureValidationConfiguration>();
        RelyingPartyContext rpc = this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            SecurityConfiguration defaultConfig;
            SecurityConfiguration sc;
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc != null && (sc = pc.getSecurityConfiguration(this.getProfileRequestContextLookupStrategy().apply(input))) != null && sc.getSignatureValidationConfiguration() != null) {
                configs.add(sc.getSignatureValidationConfiguration());
            }
            if (pc != null && this.rpResolver != null && (defaultConfig = this.rpResolver.getDefaultSecurityConfiguration(pc.getId())) != null && defaultConfig.getSignatureValidationConfiguration() != null) {
                configs.add(defaultConfig.getSignatureValidationConfiguration());
            }
        }
        configs.add(SecurityConfigurationSupport.getGlobalSignatureValidationConfiguration());
        return configs;
    }
}

