/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config.navigate.messaging;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.messaging.AbstractRelyingPartyLookupFunction;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.security.httpclient.HttpClientSecurityConfiguration;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;

public class HttpClientSecurityConfigurationLookupFunction
extends AbstractRelyingPartyLookupFunction<List<HttpClientSecurityConfiguration>> {
    @Nullable
    private RelyingPartyConfigurationResolver rpResolver;

    public void setRelyingPartyConfigurationResolver(@Nullable RelyingPartyConfigurationResolver resolver) {
        this.rpResolver = resolver;
    }

    @Nullable
    public List<HttpClientSecurityConfiguration> apply(@Nullable MessageContext input) {
        ArrayList<HttpClientSecurityConfiguration> configs = new ArrayList<HttpClientSecurityConfiguration>();
        RelyingPartyContext rpc = this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            SecurityConfiguration defaultConfig;
            SecurityConfiguration sc;
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc != null && (sc = pc.getSecurityConfiguration(this.getProfileRequestContextLookupStrategy().apply(input))) != null && sc.getHttpClientSecurityConfiguration() != null) {
                configs.add(sc.getHttpClientSecurityConfiguration());
            }
            if (pc != null && this.rpResolver != null && (defaultConfig = this.rpResolver.getDefaultSecurityConfiguration(pc.getId())) != null && defaultConfig.getHttpClientSecurityConfiguration() != null) {
                configs.add(defaultConfig.getHttpClientSecurityConfiguration());
            }
        }
        configs.add(HttpClientSecuritySupport.getGlobalHttpClientSecurityConfiguration());
        return configs;
    }
}

