/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config.navigate;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfigurationResolver;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;

public class SelfEncryptionConfigurationLookupFunction
implements Function<ProfileRequestContext, List<EncryptionConfiguration>> {
    @Nullable
    private EncryptionConfiguration selfConfig;
    @Nullable
    private RelyingPartyConfigurationResolver rpResolver;
    private boolean includeProfileDefaultConfiguration;

    public void setRelyingPartyConfigurationResolver(@Nullable RelyingPartyConfigurationResolver resolver) {
        this.rpResolver = resolver;
    }

    public void setSelfConfiguration(@Nullable EncryptionConfiguration config) {
        this.selfConfig = config;
    }

    public void setIncludeProfileDefaultConfiguration(boolean flag) {
        this.includeProfileDefaultConfiguration = flag;
    }

    @Nullable
    public List<EncryptionConfiguration> apply(@Nullable ProfileRequestContext input) {
        SecurityConfiguration defaultConfig;
        ArrayList<EncryptionConfiguration> configs = new ArrayList<EncryptionConfiguration>();
        if (this.selfConfig != null) {
            configs.add(this.selfConfig);
        }
        if (this.includeProfileDefaultConfiguration && input != null && this.rpResolver != null && (defaultConfig = this.rpResolver.getDefaultSecurityConfiguration(input.getProfileId())) != null && defaultConfig.getEncryptionConfiguration() != null) {
            configs.add(defaultConfig.getEncryptionConfiguration());
        }
        configs.add(SecurityConfigurationSupport.getGlobalEncryptionConfiguration());
        return configs;
    }
}

