/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.metrics.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HttpContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPReporter
extends ScheduledReporter
implements InitializableComponent {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_DT_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPReporter.class);
    @Nonnull
    private final MetricRegistry metricRegistry;
    @Nonnull
    private final MetricFilter metricFilter;
    @Nonnull
    private final TimeUnit rateUnit;
    @Nonnull
    private final TimeUnit durationUnit;
    @NonnullAfterInit
    private HttpClient httpClient;
    @NonnullAfterInit
    @NotEmpty
    private String collectorURL;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;
    @NonnullAfterInit
    private ObjectMapper jsonMapper;
    @Nullable
    private String dateTimeFormat;
    private boolean isInitialized;

    public HTTPReporter(@Nonnull @ParameterName(name="registry") MetricRegistry registry, @Nonnull @ParameterName(name="name") @NotEmpty String name, @Nullable @ParameterName(name="filter") MetricFilter filter) {
        super(registry, name, filter, TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.metricRegistry = registry;
        this.metricFilter = filter != null ? filter : MetricFilter.ALL;
        this.rateUnit = TimeUnit.SECONDS;
        this.durationUnit = TimeUnit.SECONDS;
    }

    public HTTPReporter(@Nonnull @ParameterName(name="registry") MetricRegistry registry, @Nonnull @ParameterName(name="name") @NotEmpty String name, @Nullable @ParameterName(name="filter") MetricFilter filter, @Nonnull @ParameterName(name="rUnit") TimeUnit rUnit, @Nonnull @ParameterName(name="dUnit") TimeUnit dUnit) {
        super(registry, name, filter, rUnit, dUnit);
        this.metricRegistry = registry;
        this.metricFilter = filter != null ? filter : MetricFilter.ALL;
        this.rateUnit = rUnit;
        this.durationUnit = dUnit;
    }

    public HTTPReporter(@Nonnull @ParameterName(name="registry") MetricRegistry registry, @Nonnull @ParameterName(name="name") @NotEmpty String name, @Nullable @ParameterName(name="filter") MetricFilter filter, @Nonnull @ParameterName(name="rUnit") TimeUnit rUnit, @Nonnull @ParameterName(name="dUnit") TimeUnit dUnit, @Nonnull @ParameterName(name="executor") ScheduledExecutorService executor) {
        super(registry, name, filter, rUnit, dUnit, executor);
        this.metricRegistry = registry;
        this.metricFilter = filter != null ? filter : MetricFilter.ALL;
        this.rateUnit = rUnit;
        this.durationUnit = dUnit;
    }

    public void setHttpClient(@Nonnull HttpClient client) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setCollectorURL(@Nonnull @NotEmpty String url) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.collectorURL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)url), (String)"Collector URL cannot be null or empty");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpClientSecurityParameters = params;
    }

    public void setDateTimeFormat(@Nullable @NotEmpty String format) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dateTimeFormat = StringSupport.trimOrNull((String)format);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() throws ComponentInitializationException {
        if (!this.isInitialized) {
            if (this.httpClient == null || this.collectorURL == null) {
                throw new ComponentInitializationException("HttpClient and collection URL cannot be null");
            }
            this.jsonMapper = new ObjectMapper().registerModule((Module)new MetricsModule(this.rateUnit, this.durationUnit, true, this.metricFilter));
            this.jsonMapper.registerModule((Module)new JavaTimeModule());
            this.jsonMapper.setDateFormat((DateFormat)new SimpleDateFormat(this.dateTimeFormat != null ? this.dateTimeFormat : DEFAULT_DT_FORMAT));
            this.jsonMapper.configure(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
            this.isInitialized = true;
        }
    }

    public void stop() {
        super.stop();
        this.httpClient = null;
        this.httpClientSecurityParameters = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report() {
        HTTPReporter hTTPReporter = this;
        synchronized (hTTPReporter) {
            try {
                HttpPost httpRequest = new HttpPost(this.collectorURL);
                HttpClientContext httpContext = this.buildHttpContext((HttpUriRequest)httpRequest);
                ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
                ObjectWriter writer = this.jsonMapper.writer();
                writer.writeValue((OutputStream)output, (Object)this.metricRegistry);
                EntityBuilder entityBuilder = EntityBuilder.create();
                entityBuilder.setContentType(ContentType.APPLICATION_JSON);
                entityBuilder.setBinary(output.toByteArray());
                httpRequest.setEntity(entityBuilder.build());
                HttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)httpContext);
                HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)httpContext, (String)httpRequest.getURI().getScheme());
                if (response.getStatusLine().getStatusCode() == 200) {
                    this.log.debug("Metrics delivered successfully to collector");
                } else {
                    this.log.error("Collector responded with HTTP status {}", (Object)response.getStatusLine().getStatusCode());
                }
            }
            catch (IOException e) {
                this.log.error("Error sending metric registry to collection point {}", (Object)this.collectorURL, (Object)e);
            }
        }
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        throw new UnsupportedOperationException("The per-metric report method should never be called.");
    }

    @Nonnull
    private HttpClientContext buildHttpContext(@Nonnull HttpUriRequest request) {
        HttpClientContext clientContext = HttpClientContext.create();
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)this.httpClientSecurityParameters, (boolean)false);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpUriRequest)request);
        return clientContext;
    }
}

