/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.log;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.shibboleth.idp.Version;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import org.slf4j.MDC;

public class SLF4JMDCServletFilter
implements Filter {
    @Nonnull
    @NotEmpty
    public static final String SERVER_ADDRESS_MDC_ATTRIBUTE = "idp.server_hostname";
    @Nonnull
    @NotEmpty
    public static final String SERVER_PORT_MDC_ATTRIBUTE = "idp.server_port";
    @Nonnull
    @NotEmpty
    public static final String CLIENT_ADDRESS_MDC_ATTRIBUTE = "idp.remote_addr";
    @Nonnull
    @NotEmpty
    public static final String JSESSIONID_MDC_ATTRIBUTE = "idp.jsessionid";
    private boolean createSession;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpSession session;
            MDC.put((String)"idp.version", (String)Version.getVersion());
            MDC.put((String)CLIENT_ADDRESS_MDC_ATTRIBUTE, (String)HttpServletSupport.getRemoteAddr((ServletRequest)request));
            MDC.put((String)SERVER_ADDRESS_MDC_ATTRIBUTE, (String)request.getServerName());
            MDC.put((String)SERVER_PORT_MDC_ATTRIBUTE, (String)Integer.toString(request.getServerPort()));
            if (request instanceof HttpServletRequest && (session = ((HttpServletRequest)request).getSession(this.createSession)) != null) {
                MDC.put((String)JSESSIONID_MDC_ATTRIBUTE, (String)session.getId());
            }
            chain.doFilter(request, response);
        }
        finally {
            MDC.clear();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String param = filterConfig.getInitParameter("createSession");
        this.createSession = param != null ? Boolean.valueOf(param) : true;
    }

    public void destroy() {
    }
}

