/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cli;

import com.beust.jcommander.Parameter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cli.AbstractCommandLineArguments;

public class MetadataQueryArguments
extends AbstractCommandLineArguments {
    @Parameter(names={"-e", "--entityID"}, required=true, description="EntityID to find metadata for")
    @Nullable
    private String entityID;
    @Parameter(names={"--protocol"}, description="Optional protocol to find metadata role for")
    @Nullable
    private String protocol;
    @Parameter(names={"--saml1"}, description="Query for SAML 1.1 role")
    private boolean saml1;
    @Parameter(names={"--saml2"}, description="Query for SAML 2.0 role")
    private boolean saml2;
    @Parameter(names={"--cas"}, description="Query for CAS role")
    private boolean cas;

    @Override
    public void validate() {
        try {
            if (this.saml1 ? this.saml2 || this.cas || this.protocol != null : (this.saml2 ? this.cas || this.protocol != null : this.cas && this.protocol != null)) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The saml1, saml2, cas, and protocol options are mutually exclusive");
        }
    }

    @Override
    protected StringBuilder doBuildURL(@Nonnull StringBuilder builder) {
        if (this.getPath() == null) {
            builder.append("/profile/admin/mdquery");
        }
        if (builder.toString().contains("?")) {
            builder.append('&');
        } else {
            builder.append('?');
        }
        try {
            builder.append("entityID=").append(URLEncoder.encode(this.entityID, "UTF-8"));
            if (this.saml1) {
                builder.append("&saml1");
            } else if (this.saml2) {
                builder.append("&saml2");
            } else if (this.cas) {
                builder.append("&cas");
            } else if (this.protocol != null) {
                builder.append("&protocol=").append(URLEncoder.encode(this.protocol, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return builder;
    }
}

