/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.storage.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsentSerializer
extends AbstractInitializableComponent
implements StorageSerializer<Map<String, Consent>> {
    @Nonnull
    @NotEmpty
    private static final String ID_FIELD = "id";
    @Nonnull
    @NotEmpty
    private static final String VALUE_FIELD = "v";
    @Nonnull
    @NotEmpty
    private static final String IS_APPROVED_FIELD = "appr";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ConsentSerializer.class);
    @Nonnull
    private final JsonGeneratorFactory generatorFactory;
    @Nonnull
    private final JsonReaderFactory readerFactory;
    @Nonnull
    @NonnullElements
    private BiMap<String, Integer> symbolics;

    public ConsentSerializer() {
        JsonProvider provider = JsonProvider.provider();
        this.generatorFactory = provider.createGeneratorFactory(null);
        this.readerFactory = provider.createReaderFactory(null);
        this.symbolics = ImmutableBiMap.of();
    }

    public void setSymbolics(@Nonnull @NonnullElements Map<String, Integer> mappings) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.symbolics = HashBiMap.create((Map)((Map)Constraint.isNotNull(mappings, (String)"Symbolic mappings cannot be null")));
    }

    @Nullable
    protected String desymbolize(@Nonnull JsonValue field) {
        if (field == null) {
            return null;
        }
        switch (field.getValueType()) {
            case STRING: {
                return ((JsonString)field).getString();
            }
            case NUMBER: {
                return (String)this.symbolics.inverse().get((Object)((JsonNumber)field).intValueExact());
            }
        }
        return null;
    }

    @Nonnull
    public Map<String, Consent> deserialize(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        LinkedHashMap<String, Consent> linkedHashMap;
        block12: {
            JsonReader reader = this.readerFactory.createReader((Reader)new StringReader(value));
            try {
                JsonStructure st = reader.read();
                if (!(st instanceof JsonArray)) {
                    throw new IOException("Found invalid data structure while parsing consent");
                }
                JsonArray array = (JsonArray)st;
                LinkedHashMap<String, Consent> consents = new LinkedHashMap<String, Consent>();
                for (JsonValue a : array) {
                    if (!a.getValueType().equals((Object)JsonValue.ValueType.OBJECT)) continue;
                    JsonObject o = (JsonObject)a;
                    String consentId = this.desymbolize((JsonValue)o.get((Object)ID_FIELD));
                    if (consentId == null) {
                        this.log.warn("Unparseable consent id in structure");
                        continue;
                    }
                    Consent consent = new Consent();
                    consent.setId(consentId);
                    if (o.containsKey((Object)VALUE_FIELD)) {
                        consent.setValue(o.getString(VALUE_FIELD));
                    }
                    consent.setApproved(o.getBoolean(IS_APPROVED_FIELD, true));
                    consents.put(consent.getId(), consent);
                }
                this.log.debug("Deserialized context '{}' key '{}' value '{}' expiration '{}' as '{}'", new Object[]{context, key, value, expiration, consents});
                linkedHashMap = consents;
                if (reader == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ArithmeticException | ClassCastException | NullPointerException | JsonException e) {
                    this.log.error("Exception while parsing consent: {}", (Object)e.getMessage());
                    throw new IOException("Found invalid data structure while parsing consent", e);
                }
            }
            reader.close();
        }
        return linkedHashMap;
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Map<String, Consent> consents) throws IOException {
        Constraint.isNotNull(consents, (String)"Consents cannot be null");
        List filteredConsents = consents.values().stream().filter(e -> e != null).collect(Collectors.toList());
        Constraint.isNotEmpty(filteredConsents, (String)"Consents cannot be empty");
        StringWriter sink = new StringWriter(128);
        try (JsonGenerator gen = this.generatorFactory.createGenerator((Writer)sink);){
            gen.writeStartArray();
            for (Consent consent : filteredConsents) {
                gen.writeStartObject();
                Integer symbol = (Integer)this.symbolics.get((Object)consent.getId());
                if (symbol != null) {
                    gen.write(ID_FIELD, symbol.intValue());
                } else {
                    gen.write(ID_FIELD, consent.getId());
                }
                if (consent.getValue() != null) {
                    gen.write(VALUE_FIELD, consent.getValue());
                }
                if (!consent.isApproved()) {
                    gen.write(IS_APPROVED_FIELD, false);
                }
                gen.writeEnd();
            }
            gen.writeEnd();
        }
        String serialized = sink.toString();
        this.log.debug("Serialized '{}' as '{}'", consents, (Object)serialized);
        return serialized;
    }
}

