/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.ar.impl;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.flow.ar.impl.AbstractAttributeReleaseAction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseAttributes
extends AbstractAttributeReleaseAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReleaseAttributes.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        Map consents = this.getConsentContext().getCurrentConsents().isEmpty() ? this.getConsentContext().getPreviousConsents() : this.getConsentContext().getCurrentConsents();
        this.log.debug("{} Consents '{}'", (Object)this.getLogPrefix(), (Object)consents);
        Map attributes = this.getAttributeContext().getIdPAttributes();
        this.log.debug("{} Attributes before release '{}'", (Object)this.getLogPrefix(), (Object)attributes);
        HashMap<String, IdPAttribute> releasedAttributes = new HashMap<String, IdPAttribute>(attributes.size());
        for (IdPAttribute attribute : attributes.values()) {
            if (!this.getAttributeReleaseContext().getConsentableAttributes().containsKey(attribute.getId())) {
                this.log.debug("{} Attribute '{}' will be released because it is excluded from consent", (Object)this.getLogPrefix(), (Object)attribute);
                releasedAttributes.put(attribute.getId(), attribute);
                continue;
            }
            if (!consents.containsKey(attribute.getId())) {
                this.log.debug("{} Attribute '{}' will not be released because consent for it does not exist", (Object)this.getLogPrefix(), (Object)attribute);
                continue;
            }
            Consent consent = (Consent)consents.get(attribute.getId());
            if (consent.isApproved()) {
                this.log.debug("{} Attribute '{}' will be released because consent is approved", (Object)this.getLogPrefix(), (Object)attribute);
                releasedAttributes.put(attribute.getId(), attribute);
                continue;
            }
            this.log.debug("{} Attribute '{}' will not be released because consent is not approved", (Object)this.getLogPrefix(), (Object)attribute);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} Releasing attributes '{}'", (Object)this.getLogPrefix(), releasedAttributes);
            MapDifference diff = Maps.difference((Map)attributes, releasedAttributes);
            this.log.debug("{} Not releasing attributes '{}'", (Object)this.getLogPrefix(), (Object)diff.entriesOnlyOnLeft());
        }
        this.getAttributeContext().setIdPAttributes(releasedAttributes.values());
    }
}

